/*	$OpenBSD: spleen8x16-ibm.h,v 1.1 2023/10/19 06:47:36 fcambus Exp $ */

/*
 * Copyright (c) 2018-2023 Frederic Cambus <fcambus@openbsd.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

static u_char spleen8x16_ibm_data[];

struct wsdisplay_font spleen8x16_ibm = {
	.name		= "Spleen 8x16 IBM CP437",
	.index		= 0,
	.firstchar	= 1,
	.numchars	= 254,
	.encoding	= WSDISPLAY_FONTENC_IBM,
	.fontwidth	= 8,
	.fontheight	= 16,
	.stride		= 1,
	.bitorder	= WSDISPLAY_FONTORDER_L2R,
	.byteorder	= WSDISPLAY_FONTORDER_L2R,
	.cookie		= NULL,
	.data		= spleen8x16_ibm_data
};

static u_char spleen8x16_ibm_data[] = {
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x81, 	/* *......* */
	0xa5, 	/* *.*..*.* */
	0x81, 	/* *......* */
	0x81, 	/* *......* */
	0xa5, 	/* *.*..*.* */
	0x99, 	/* *..**..* */
	0x81, 	/* *......* */
	0x81, 	/* *......* */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xff, 	/* ******** */
	0xdb, 	/* **.**.** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xdb, 	/* **.**.** */
	0xe7, 	/* ***..*** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0x7c, 	/* .*****.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x7c, 	/* .*****.. */
	0xfe, 	/* *******. */
	0x7c, 	/* .*****.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0xe7, 	/* ***..*** */
	0xe7, 	/* ***..*** */
	0xe7, 	/* ***..*** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x7e, 	/* .******. */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xe7, 	/* ***..*** */
	0xc3, 	/* **....** */
	0xc3, 	/* **....** */
	0xe7, 	/* ***..*** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xc3, 	/* **....** */
	0x99, 	/* *..**..* */
	0x99, 	/* *..**..* */
	0x99, 	/* *..**..* */
	0x99, 	/* *..**..* */
	0xc3, 	/* **....** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0f, 	/* ....**** */
	0x07, 	/* .....*** */
	0x0d, 	/* ....**.* */
	0x19, 	/* ...**..* */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x66, 	/* .**..**. */
	0x7e, 	/* .******. */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x66, 	/* .**..**. */
	0x7e, 	/* .******. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x6e, 	/* .**.***. */
	0xcc, 	/* **..**.. */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xdb, 	/* **.**.** */
	0x3c, 	/* ..****.. */
	0xe7, 	/* ***..*** */
	0x3c, 	/* ..****.. */
	0xdb, 	/* **.**.** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x80, 	/* *....... */
	0xc0, 	/* **...... */
	0xe0, 	/* ***..... */
	0xf0, 	/* ****.... */
	0xf8, 	/* *****... */
	0xfc, 	/* ******.. */
	0xfe, 	/* *******. */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xfe, 	/* *******. */
	0xfc, 	/* ******.. */
	0xf8, 	/* *****... */
	0xf0, 	/* ****.... */
	0xe0, 	/* ***..... */
	0xc0, 	/* **...... */
	0x80, 	/* *....... */

	0x01, 	/* .......* */
	0x03, 	/* ......** */
	0x07, 	/* .....*** */
	0x0f, 	/* ....**** */
	0x1f, 	/* ...***** */
	0x3f, 	/* ..****** */
	0x7f, 	/* .******* */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x7f, 	/* .******* */
	0x3f, 	/* ..****** */
	0x1f, 	/* ...***** */
	0x0f, 	/* ....**** */
	0x07, 	/* .....*** */
	0x03, 	/* ......** */
	0x01, 	/* .......* */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0x76, 	/* .***.**. */
	0x16, 	/* ...*.**. */
	0x16, 	/* ...*.**. */
	0x16, 	/* ...*.**. */
	0x16, 	/* ...*.**. */
	0x16, 	/* ...*.**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x08, 	/* ....*... */
	0x04, 	/* .....*.. */
	0xfe, 	/* *******. */
	0x04, 	/* .....*.. */
	0x08, 	/* ....*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x20, 	/* ..*..... */
	0x40, 	/* .*...... */
	0xfe, 	/* *******. */
	0x40, 	/* .*...... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x28, 	/* ..*.*... */
	0x6c, 	/* .**.**.. */
	0xfe, 	/* *******. */
	0x6c, 	/* .**.**.. */
	0x28, 	/* ..*.*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0xfe, 	/* *******. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0xfe, 	/* *******. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x7e, 	/* .******. */
	0xd0, 	/* **.*.... */
	0xd0, 	/* **.*.... */
	0xd0, 	/* **.*.... */
	0x7c, 	/* .*****.. */
	0x16, 	/* ...*.**. */
	0x16, 	/* ...*.**. */
	0x16, 	/* ...*.**. */
	0x16, 	/* ...*.**. */
	0xfc, 	/* ******.. */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x66, 	/* .**..**. */
	0x6c, 	/* .**.**.. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x36, 	/* ..**.**. */
	0x66, 	/* .**..**. */
	0x60, 	/* .**..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x70, 	/* .***.... */
	0xda, 	/* **.**.*. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0x7a, 	/* .****.*. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x0e, 	/* ....***. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0e, 	/* ....***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xce, 	/* **..***. */
	0xde, 	/* **.****. */
	0xf6, 	/* ****.**. */
	0xe6, 	/* ***..**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x38, 	/* ..***... */
	0x78, 	/* .****... */
	0x58, 	/* .*.**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x3c, 	/* ..****.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xfe, 	/* *******. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc2, 	/* **....*. */
	0xda, 	/* **.**.*. */
	0xda, 	/* **.**.*. */
	0xda, 	/* **.**.*. */
	0xda, 	/* **.**.*. */
	0xde, 	/* **.****. */
	0xc0, 	/* **...... */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xf8, 	/* *****... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xf8, 	/* *****... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xde, 	/* **.****. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xf0, 	/* ****.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xcc, 	/* **..**.. */
	0xf8, 	/* *****... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xee, 	/* ***.***. */
	0xfe, 	/* *******. */
	0xd6, 	/* **.*.**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xe6, 	/* ***..**. */
	0xe6, 	/* ***..**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xce, 	/* **..***. */
	0xce, 	/* **..***. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0x7c, 	/* .*****.. */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xd6, 	/* **.*.**. */
	0xfe, 	/* *******. */
	0xee, 	/* ***.***. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x3e, 	/* ..*****. */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x3e, 	/* ..*****. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1e, 	/* ...****. */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x7c, 	/* .*****.. */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1c, 	/* ...***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xcc, 	/* **..**.. */
	0xd8, 	/* **.**... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xd8, 	/* **.**... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x1c, 	/* ...***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xec, 	/* ***.**.. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x7c, 	/* .*****.. */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x1e, 	/* ...****. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0x6e, 	/* .**.***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x0e, 	/* ....***. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x70, 	/* .***.... */
	0x70, 	/* .***.... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x0e, 	/* ....***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x0e, 	/* ....***. */
	0x0e, 	/* ....***. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x32, 	/* ..**..*. */
	0x7e, 	/* .******. */
	0x4c, 	/* .*..**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1c, 	/* ...***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1c, 	/* ...***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1c, 	/* ...***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xf8, 	/* *****... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6e, 	/* .**.***. */
	0x16, 	/* ...*.**. */
	0x16, 	/* ...*.**. */
	0x7e, 	/* .******. */
	0xd0, 	/* **.*.... */
	0xd0, 	/* **.*.... */
	0x6e, 	/* .**.***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xfe, 	/* *******. */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xde, 	/* **.****. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */

	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x08, 	/* ....*... */
	0x7e, 	/* .******. */
	0xc8, 	/* **..*... */
	0xc8, 	/* **..*... */
	0xc8, 	/* **..*... */
	0xc8, 	/* **..*... */
	0xc8, 	/* **..*... */
	0x7e, 	/* .******. */
	0x08, 	/* ....*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xf8, 	/* *****... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc3, 	/* **....** */
	0xc3, 	/* **....** */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xf8, 	/* *****... */
	0xc0, 	/* **...... */
	0xcc, 	/* **..**.. */
	0xde, 	/* **.****. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0e, 	/* ....***. */
	0x1b, 	/* ...**.** */
	0x1b, 	/* ...**.** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1c, 	/* ...***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x32, 	/* ..**..*. */
	0x7e, 	/* .******. */
	0x4c, 	/* .*..**.. */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x32, 	/* ..**..*. */
	0x4c, 	/* .*..**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xe6, 	/* ***..**. */
	0xe6, 	/* ***..**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xce, 	/* **..***. */
	0xce, 	/* **..***. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x0c, 	/* ....**.. */
	0x3c, 	/* ..****.. */
	0x4c, 	/* .*..**.. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x40, 	/* .*...... */
	0xc0, 	/* **...... */
	0x40, 	/* .*...... */
	0x42, 	/* .*....*. */
	0x46, 	/* .*...**. */
	0xec, 	/* ***.**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x6c, 	/* .**.**.. */
	0xd2, 	/* **.*..*. */
	0x82, 	/* *.....*. */
	0x0c, 	/* ....**.. */
	0x10, 	/* ...*.... */
	0x1e, 	/* ...****. */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x40, 	/* .*...... */
	0xc0, 	/* **...... */
	0x40, 	/* .*...... */
	0x42, 	/* .*....*. */
	0x46, 	/* .*...**. */
	0xec, 	/* ***.**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x70, 	/* .***.... */
	0xd4, 	/* **.*.*.. */
	0x94, 	/* *..*.*.. */
	0x1e, 	/* ...****. */
	0x04, 	/* .....*.. */
	0x04, 	/* .....*.. */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x33, 	/* ..**..** */
	0x66, 	/* .**..**. */
	0xcc, 	/* **..**.. */
	0x66, 	/* .**..**. */
	0x33, 	/* ..**..** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xcc, 	/* **..**.. */
	0x66, 	/* .**..**. */
	0x33, 	/* ..**..** */
	0x66, 	/* .**..**. */
	0xcc, 	/* **..**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x11, 	/* ...*...* */
	0x44, 	/* .*...*.. */
	0x11, 	/* ...*...* */
	0x44, 	/* .*...*.. */
	0x11, 	/* ...*...* */
	0x44, 	/* .*...*.. */
	0x11, 	/* ...*...* */
	0x44, 	/* .*...*.. */
	0x11, 	/* ...*...* */
	0x44, 	/* .*...*.. */
	0x11, 	/* ...*...* */
	0x44, 	/* .*...*.. */
	0x11, 	/* ...*...* */
	0x44, 	/* .*...*.. */
	0x11, 	/* ...*...* */
	0x44, 	/* .*...*.. */

	0x55, 	/* .*.*.*.* */
	0xaa, 	/* *.*.*.*. */
	0x55, 	/* .*.*.*.* */
	0xaa, 	/* *.*.*.*. */
	0x55, 	/* .*.*.*.* */
	0xaa, 	/* *.*.*.*. */
	0x55, 	/* .*.*.*.* */
	0xaa, 	/* *.*.*.*. */
	0x55, 	/* .*.*.*.* */
	0xaa, 	/* *.*.*.*. */
	0x55, 	/* .*.*.*.* */
	0xaa, 	/* *.*.*.*. */
	0x55, 	/* .*.*.*.* */
	0xaa, 	/* *.*.*.*. */
	0x55, 	/* .*.*.*.* */
	0xaa, 	/* *.*.*.*. */

	0xdd, 	/* **.***.* */
	0x77, 	/* .***.*** */
	0xdd, 	/* **.***.* */
	0x77, 	/* .***.*** */
	0xdd, 	/* **.***.* */
	0x77, 	/* .***.*** */
	0xdd, 	/* **.***.* */
	0x77, 	/* .***.*** */
	0xdd, 	/* **.***.* */
	0x77, 	/* .***.*** */
	0xdd, 	/* **.***.* */
	0x77, 	/* .***.*** */
	0xdd, 	/* **.***.* */
	0x77, 	/* .***.*** */
	0xdd, 	/* **.***.* */
	0x77, 	/* .***.*** */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0xf6, 	/* ****.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0xf6, 	/* ****.**. */
	0x06, 	/* .....**. */
	0xf6, 	/* ****.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x06, 	/* .....**. */
	0xf6, 	/* ****.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0xf6, 	/* ****.**. */
	0x06, 	/* .....**. */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x37, 	/* ..**.*** */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x37, 	/* ..**.*** */
	0x30, 	/* ..**.... */
	0x3f, 	/* ..****** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3f, 	/* ..****** */
	0x30, 	/* ..**.... */
	0x37, 	/* ..**.*** */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0xf7, 	/* ****.*** */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0xf7, 	/* ****.*** */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x37, 	/* ..**.*** */
	0x30, 	/* ..**.... */
	0x37, 	/* ..**.*** */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0xf7, 	/* ****.*** */
	0x00, 	/* ........ */
	0xf7, 	/* ****.*** */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x3f, 	/* ..****** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3f, 	/* ..****** */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0xff, 	/* ******** */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */

	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */

	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */

	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xdc, 	/* **.***.. */
	0x76, 	/* .***.**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xd8, 	/* **.**... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xd6, 	/* **.*.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xf6, 	/* ****.**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x7c, 	/* .*****.. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0x7c, 	/* .*****.. */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0xee, 	/* ***.***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1e, 	/* ...****. */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xdb, 	/* **.**.** */
	0xdb, 	/* **.**.** */
	0xdb, 	/* **.**.** */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x4c, 	/* .*..**.. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0x7c, 	/* .*****.. */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0x70, 	/* .***.... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0e, 	/* ....***. */
	0x1b, 	/* ...**.** */
	0x1b, 	/* ...**.** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x32, 	/* ..**..*. */
	0x4c, 	/* .*..**.. */
	0x00, 	/* ........ */
	0x32, 	/* ..**..*. */
	0x4c, 	/* .*..**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x0f, 	/* ....**** */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0xcc, 	/* **..**.. */
	0x6c, 	/* .**.**.. */
	0x3c, 	/* ..****.. */
	0x1c, 	/* ...***.. */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x4c, 	/* .*..**.. */
	0x0c, 	/* ....**.. */
	0x38, 	/* ..***... */
	0x60, 	/* .**..... */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
};
