/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.spec.AlgorithmParameterSpec;
import net.i2p.data.DataHelper;

public enum SigContext {
    SC_NONE(null),
    SC_DATAGRAM("sign_datagramI2P"),
    SC_I2CP("I2CP_SessionConf"),
    SC_NETDB("network_database"),
    SC_NTCP("NTCP_1_handshake"),
    SC_SSU("SSUHandshakeSign"),
    SC_STREAMING("streaming_i2psig"),
    SC_SU3("i2pSU3FileFormat"),
    SC_TEST("test1234test5678");

    private final SigContextSpec spec;

    private SigContext(String p) {
        this.spec = new SigContextSpec(p);
    }

    public SigContextSpec getSpec() {
        return this.spec;
    }

    public static class SigContextSpec
    implements AlgorithmParameterSpec {
        private final byte[] b;

        public SigContextSpec(String p) {
            if (p != null) {
                this.b = DataHelper.getASCII(p);
                if (this.b.length != 16) {
                    throw new IllegalArgumentException();
                }
            } else {
                this.b = null;
            }
        }

        public byte[] getData() {
            return this.b;
        }
    }
}

