/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.shared.common.error.StandardException;

public abstract class KeyConstraintDescriptor
extends ConstraintDescriptor {
    UUID indexId;
    private ConglomerateDescriptor indexConglom;

    KeyConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, int[] referencedColumns, UUID constraintId, UUID indexId, SchemaDescriptor schemaDesc, boolean enforced) {
        super(dataDictionary, table, constraintName, deferrable, initiallyDeferred, referencedColumns, constraintId, schemaDesc, enforced);
        this.indexId = indexId;
    }

    public UUID getIndexId() {
        return this.indexId;
    }

    public ConglomerateDescriptor getIndexConglomerateDescriptor(DataDictionary dd) throws StandardException {
        if (this.indexConglom == null) {
            this.indexConglom = this.getTableDescriptor().getConglomerateDescriptor(this.indexId);
        }
        return this.indexConglom;
    }

    public String getIndexUUIDString() {
        return this.indexId.toString();
    }

    @Override
    public boolean hasBackingIndex() {
        return true;
    }

    @Override
    public UUID getConglomerateId() {
        return this.indexId;
    }

    @Override
    public String toString() {
        return "indexId: " + String.valueOf(this.indexId) + "\n" + super.toString();
    }
}

