/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.AggregateSortObserver;
import org.apache.derby.impl.sql.execute.GenericAggregator;
import org.apache.derby.impl.sql.execute.ScalarAggregateResultSet;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class DistinctScalarAggregateResultSet
extends ScalarAggregateResultSet {
    private ColumnOrdering[] order;
    private int maxRowSize;
    private boolean dropDistinctAggSort;
    private long sortId;
    private ScanController scanController;
    private ExecIndexRow sortResultRow;
    private boolean sorted;

    DistinctScalarAggregateResultSet(NoPutResultSet s, boolean isInSortedOrder, int aggregateItem, int orderingItem, Activation a, int ra, int maxRowSize, int resultSetNumber, boolean singleInputRow, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(s, isInSortedOrder, aggregateItem, a, ra, resultSetNumber, singleInputRow, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.order = (ColumnOrdering[])((FormatableArrayHolder)a.getPreparedStatement().getSavedObject(orderingItem)).getArray(ColumnOrdering[].class);
        this.maxRowSize = maxRowSize;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"DistinctScalarResultSet already open");
        this.sortResultRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.sourceExecIndexRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.source.openCore();
        try {
            this.scanController = this.loadSorter();
        }
        catch (StandardException e) {
            this.isOpen = true;
            try {
                this.close();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw e;
        }
        this.sorted = true;
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecIndexRow execIndexRow = null;
        ExecIndexRow aggResult = null;
        boolean cloneArg = true;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            while ((execIndexRow = this.getRowFromResultSet(cloneArg)) != null) {
                if (aggResult == null) {
                    cloneArg = false;
                    aggResult = (ExecIndexRow)execIndexRow.getClone();
                    continue;
                }
                this.accumulateScalarAggregation(execIndexRow, aggResult, true);
            }
            if (this.countOfRows == 0) {
                aggResult = this.finishAggregation(aggResult);
                this.setCurrentRow(aggResult);
                ++this.countOfRows;
            }
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return aggResult;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT((boolean)this.isOpen, (String)"NormalizeResultSet already open");
        if (this.scanController != null) {
            this.scanController.close();
            this.scanController = null;
        }
        this.source.reopenCore();
        this.scanController = this.loadSorter();
        this.sorted = true;
        ++this.numOpens;
        this.countOfRows = 0;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void close() throws StandardException {
        super.close();
        this.closeSource();
    }

    @Override
    public ExecIndexRow getRowFromResultSet(boolean doClone) throws StandardException {
        ExecIndexRow inputRow = null;
        if (this.scanController.next()) {
            this.currentRow = doClone ? this.sortResultRow.getClone() : this.sortResultRow;
            inputRow = this.getExecutionFactory().getIndexableRow(this.currentRow);
            this.scanController.fetch(inputRow.getRowArray());
        }
        return inputRow;
    }

    protected void closeSource() throws StandardException {
        if (this.scanController != null) {
            if (this.dropDistinctAggSort) {
                try {
                    this.getTransactionController().dropSort(this.sortId);
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
                this.dropDistinctAggSort = false;
            }
            this.scanController.close();
            this.scanController = null;
        }
        this.source.close();
    }

    private ScanController loadSorter() throws StandardException {
        ExecRow sourceRow;
        ExecIndexRow sortTemplateRow = this.getRowTemplate();
        int inputRowCountEstimate = (int)this.optimizerEstimatedRowCount;
        TransactionController tc = this.getTransactionController();
        GenericAggregator[] aggsNoDistinct = this.getSortAggregators(this.aggInfoList, true, this.activation.getLanguageConnectionContext(), this.source);
        AggregateSortObserver sortObserver = new AggregateSortObserver(true, aggsNoDistinct, this.aggregates, sortTemplateRow);
        this.sortId = tc.createSort(null, sortTemplateRow.getRowArray(), this.order, sortObserver, false, inputRowCountEstimate, this.maxRowSize);
        SortController sorter = tc.openSort(this.sortId);
        this.dropDistinctAggSort = true;
        while ((sourceRow = this.source.getNextRowCore()) != null) {
            sorter.insert(sourceRow.getRowArray());
            ++this.rowsInput;
        }
        sorter.completedInserts();
        this.scanController = tc.openSortScan(this.sortId, this.activation.getResultSetHoldability());
        inputRowCountEstimate = this.rowsInput;
        return this.scanController;
    }
}

