/*
 * Decompiled with CFR 0.152.
 */
package lucee.cli;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import lucee.cli.CLIFactory;
import lucee.cli.CLIInvokerImpl;
import lucee.loader.util.Util;

public class CLI {
    public static void main(String[] args) throws ServletException, IOException, JspException {
        File root;
        Map<String, String> config = CLI.toMap(args);
        System.setProperty("lucee.cli.call", "true");
        boolean useRMI = "true".equalsIgnoreCase(config.get("rmi"));
        String param = config.get("webroot");
        if (Util.isEmpty(param, true)) {
            root = new File(".");
            config.put("webroot", root.getAbsolutePath());
        } else {
            root = new File(param);
            root.mkdirs();
        }
        String servletName = config.get("servlet-name");
        if (Util.isEmpty(servletName, true)) {
            servletName = "CFMLServlet";
        }
        if (useRMI) {
            CLIFactory factory = new CLIFactory(root, servletName, config);
            factory.setDaemon(false);
            factory.start();
        } else {
            CLIInvokerImpl invoker = new CLIInvokerImpl(root, servletName);
            invoker.invoke(config);
        }
    }

    private static Map<String, String> toMap(String[] args) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (args != null && args.length > 0) {
            for (String arg : args) {
                String value;
                String key;
                String raw = arg.trim();
                if (raw.startsWith("-")) {
                    raw = raw.substring(1);
                }
                if (raw.isEmpty()) continue;
                int index = raw.indexOf(61);
                if (index == -1) {
                    key = raw;
                    value = "";
                } else {
                    key = raw.substring(0, index).trim();
                    value = raw.substring(index + 1).trim();
                }
                config.put(key.toLowerCase(), value);
            }
        }
        return config;
    }
}

