/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.server.data;

import com.projectlibre1.association.AssociationList;
import com.projectlibre1.configuration.Settings;
import com.projectlibre1.exchange.ImportedCalendarService;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.VoidNodeImpl;
import com.projectlibre1.grouping.core.model.NodeModelUtil;
import com.projectlibre1.job.JobRunnable;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.calendar.WorkingCalendar;
import com.projectlibre1.pm.dependency.Dependency;
import com.projectlibre1.pm.key.uniqueid.UniqueIdException;
import com.projectlibre1.pm.resource.ResourceImpl;
import com.projectlibre1.pm.snapshot.Snapshottable;
import com.projectlibre1.pm.task.NormalTask;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.task.TaskSnapshot;
import com.projectlibre1.server.data.CommonDataObject;
import com.projectlibre1.server.data.DataObject;
import com.projectlibre1.server.data.MPXConverter;
import com.projectlibre1.server.data.ProjectSerializer;
import com.projectlibre1.server.data.linker.Linker;
import com.projectlibre1.server.data.linker.ResourceLinker;
import com.projectlibre1.server.data.linker.TaskLinker;
import com.projectlibre1.server.data.mspdi.ModifiedMSPDIWriter;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Alert;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;

public class MSPDISerializer
implements ProjectSerializer {
    public static final boolean TMP_FILES = false;
    protected JobRunnable job = null;
    protected Linker resourceLinker = new ResourceLinker(this){

        @Override
        public Object addTransformedObjects(Object object) throws Exception {
            Project project = (Project)this.parent;
            ModifiedMSPDIWriter modifiedMSPDIWriter = (ModifiedMSPDIWriter)this.transformedParent;
            ResourceImpl resourceImpl = (ResourceImpl)object;
            Resource resource = modifiedMSPDIWriter.getProjectFile().addResource();
            MPXConverter.toMPXResource(resourceImpl, resource);
            this.transformationMap.put(resourceImpl, resource);
            return resource;
        }

        @Override
        public boolean addOutlineElement(Object object, Object object2, long l) {
            return true;
        }
    };
    protected Linker taskLinker = new TaskLinker(this){

        @Override
        public Object addTransformedObjects(Object object) throws Exception {
            Project project = (Project)this.parent;
            ModifiedMSPDIWriter modifiedMSPDIWriter = (ModifiedMSPDIWriter)this.transformedParent;
            NormalTask normalTask = (NormalTask)object;
            Task task = modifiedMSPDIWriter.getProjectFile().addTask();
            MPXConverter.toMPXTask(normalTask, task);
            Map map = (Map)this.args[0];
            for (int i = 0; i < Settings.numBaselines(); ++i) {
                AssociationList associationList;
                TaskSnapshot taskSnapshot = (TaskSnapshot)normalTask.getSnapshot(new Integer(i));
                if (taskSnapshot == null || (associationList = taskSnapshot.getHasAssignments().getAssignments()).size() <= 0) continue;
                for (Assignment assignment : associationList) {
                    ResourceImpl resourceImpl = (ResourceImpl)assignment.getResource();
                    if (i != Snapshottable.CURRENT) continue;
                    Resource resource = (Resource)map.get(resourceImpl);
                    ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
                    modifiedMSPDIWriter.putOPPrAssignmentMap(resourceAssignment, assignment);
                    modifiedMSPDIWriter.putOPPrSnapshotIdMap(resourceAssignment, new Integer(i));
                    if (i != Snapshottable.CURRENT) continue;
                    MPXConverter.toMPXAssignment(assignment, resourceAssignment);
                }
            }
            this.transformationMap.put(normalTask, task);
            return task;
        }

        @Override
        public boolean addOutlineElement(Object object, Object object2, long l) {
            if (object instanceof VoidNodeImpl) {
                return false;
            }
            Task task = (Task)this.getTransformationMap().get(object);
            Task task2 = object2 == null ? null : (Task)this.getTransformationMap().get(object2);
            task.setOutlineLevel(new Integer(task2 == null ? 1 : task2.getOutlineLevel() + 1));
            if (task2 != null) {
                task2.setSummary(true);
            }
            task.setOutlineNumber((String)(task2 == null ? "" : task2.getOutlineNumber() + ".") + (l + 1L));
            return true;
        }
    };

    protected Map saveResources(Project project, ModifiedMSPDIWriter modifiedMSPDIWriter) throws Exception {
        NodeModelUtil.enumerateNonAssignments(project.getResourcePool().getResourceOutline());
        this.resourceLinker.setParent(project);
        this.resourceLinker.setTransformedParent(modifiedMSPDIWriter);
        this.resourceLinker.init();
        this.resourceLinker.addTransformedObjects(ResourceImpl.getUnassignedInstance());
        this.resourceLinker.addTransformedObjects();
        this.resourceLinker.addOutline(null);
        return this.resourceLinker.getTransformationMap();
    }

    protected Map saveTasks(Project project, ModifiedMSPDIWriter modifiedMSPDIWriter, Map map) throws Exception {
        NodeModelUtil.enumerateNonAssignments(project.getTaskOutline());
        this.taskLinker.setParent(project);
        this.taskLinker.setTransformedParent(modifiedMSPDIWriter);
        this.taskLinker.setArgs(new Object[]{map});
        this.taskLinker.init();
        this.taskLinker.addTransformedObjects();
        this.taskLinker.addOutline(null);
        CalendarOption calendarOption = CalendarOption.getInstance();
        CalendarOption.setInstance(CalendarOption.getDefaultInstance());
        int n = 0;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = project.getTaskOutline().iterator();
        while (iterator.hasNext()) {
            Object object3;
            Object object2 = ((Node)iterator.next()).getImpl();
            if (linkedList.size() > 0 && !(object2 instanceof VoidNodeImpl)) {
                for (Object object3 : linkedList) {
                    Task task = modifiedMSPDIWriter.getProjectFile().addTask();
                    MPXConverter.toMPXVoid((VoidNodeImpl)object3, task);
                }
                linkedList.clear();
            }
            if (object2 instanceof Assignment) continue;
            if (object2 instanceof VoidNodeImpl) {
                if (n == 0) continue;
                linkedList.add(object2);
                continue;
            }
            com.projectlibre1.pm.task.Task task = (com.projectlibre1.pm.task.Task)object2;
            object3 = (Task)this.taskLinker.getTransformationMap().get(task);
            modifiedMSPDIWriter.putOPPrTaskMap(object3, task);
            for (Dependency dependency : task.getPredecessorList()) {
                com.projectlibre1.pm.task.Task task2 = (com.projectlibre1.pm.task.Task)dependency.getPredecessor();
                Task task3 = (Task)this.taskLinker.getTransformationMap().get(task2);
                Relation relation = ((Task)object3).addPredecessor(task3, RelationType.getInstance(dependency.getDependencyType()), MPXConverter.toMPXDuration(dependency.getLag()));
            }
            ++n;
        }
        CalendarOption.setInstance(calendarOption);
        return this.taskLinker.getTransformationMap();
    }

    public ModifiedMSPDIWriter serializeProject(Project project) throws Exception {
        return this.serializeProject(project, false);
    }

    public ModifiedMSPDIWriter serializeProject(Project project, boolean bl) throws Exception {
        if (bl) {
            this.makeGLobal(project);
        }
        ModifiedMSPDIWriter modifiedMSPDIWriter = new ModifiedMSPDIWriter();
        ProjectFile projectFile = new ProjectFile();
        modifiedMSPDIWriter.setProjectFile(projectFile);
        modifiedMSPDIWriter.setOPPrProject(project);
        projectFile.getProjectConfig().setAutoTaskUniqueID(true);
        projectFile.getProjectConfig().setAutoResourceUniqueID(true);
        ProjectProperties projectProperties = projectFile.getProjectProperties();
        MPXConverter.toMPXOptions(projectProperties);
        MPXConverter.toMPXProject(project, projectProperties);
        if (this.job != null) {
            this.job.setProgress(0.2f);
        }
        projectFile.getProjectConfig().setAutoCalendarUniqueID(true);
        CalendarService calendarService = CalendarService.getInstance();
        Object[] objectArray = CalendarService.allBaseCalendars();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                WorkingCalendar workingCalendar = (WorkingCalendar)objectArray[i];
                ProjectCalendar projectCalendar = projectFile.addCalendar();
                MPXConverter.toMpxCalendar(workingCalendar, projectCalendar);
                ImportedCalendarService.getInstance().addExportedCalendar(projectCalendar, workingCalendar);
            }
        }
        if (this.job != null) {
            this.job.setProgress(0.3f);
        }
        Map map = this.saveResources(project, modifiedMSPDIWriter);
        if (this.job != null) {
            this.job.setProgress(0.5f);
        }
        this.saveTasks(project, modifiedMSPDIWriter, map);
        if (this.job != null) {
            this.job.setProgress(0.7f);
        }
        return modifiedMSPDIWriter;
    }

    public void makeGLobal(DataObject dataObject) throws UniqueIdException {
        CommonDataObject.makeGlobal(dataObject);
    }

    @Override
    public boolean saveProject(Project project, String string) {
        File file;
        String string2 = "";
        String string3 = string;
        Object object = string;
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n);
            string3 = string.substring(0, n);
        }
        File file2 = file = new File(string);
        int n2 = 0;
        while (file2.exists()) {
            object = string3 + "_tmp" + n2 + string2;
            file2 = new File((String)object);
            ++n2;
        }
        try {
            if (this.saveProject(project, new FileOutputStream(file2)) && file2.length() > 0L) {
                if (!file.equals(file2)) {
                    file.delete();
                    file2.renameTo(file);
                }
                return true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (file.equals(file2)) {
            Alert.error(Messages.getString("Message.saveError"));
        } else {
            Alert.error(Messages.getString("Message.saveErrorTmpFile") + (String)object);
        }
        return false;
    }

    public boolean saveProject(Project project, OutputStream outputStream) {
        try {
            ModifiedMSPDIWriter modifiedMSPDIWriter = this.serializeProject(project);
            if (this.job != null) {
                this.job.setProgress(0.9f);
            }
            modifiedMSPDIWriter.write(modifiedMSPDIWriter.getProjectFile(), outputStream);
            if (this.job != null) {
                this.job.setProgress(1.0f);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public JobRunnable getJob() {
        return this.job;
    }

    public void setJob(JobRunnable jobRunnable) {
        this.job = jobRunnable;
    }
}

