/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.collection.Factory;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedSeqFactory;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.GrowableBuilder;
import scala.math.Integral;
import scala.math.package$;
import scala.runtime.ModuleSerializationProxy;

public final class ArrayBuffer$
implements StrictOptimizedSeqFactory<ArrayBuffer> {
    private static final long serialVersionUID = 3L;
    private static final Object[] emptyArray;
    public static final ArrayBuffer$ MODULE$;

    private ArrayBuffer$() {
    }

    static {
        MODULE$ = new ArrayBuffer$();
        IterableFactory.$init$(MODULE$);
        SeqFactory.$init$(MODULE$);
        StrictOptimizedSeqFactory.$init$(MODULE$);
        emptyArray = new Object[0];
    }

    @Override
    public Object apply(Seq elems) {
        return IterableFactory.apply$(this, elems);
    }

    @Override
    public Object iterate(Object start, int len, Function1 f) {
        return IterableFactory.iterate$(this, start, len, f);
    }

    @Override
    public Object unfold(Object init2, Function1 f) {
        return IterableFactory.unfold$(this, init2, f);
    }

    @Override
    public Object range(Object start, Object end, Integral evidence$1) {
        return IterableFactory.range$(this, start, end, evidence$1);
    }

    @Override
    public Object range(Object start, Object end, Object step, Integral evidence$1) {
        return IterableFactory.range$(this, start, end, step, evidence$1);
    }

    @Override
    public Object fill(int n1, int n2, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, elem);
    }

    @Override
    public Object fill(int n1, int n2, int n3, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, n3, elem);
    }

    @Override
    public Object fill(int n1, int n2, int n3, int n4, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, n3, n4, elem);
    }

    @Override
    public Object fill(int n1, int n2, int n3, int n4, int n5, Function0 elem) {
        return IterableFactory.fill$(this, n1, n2, n3, n4, n5, elem);
    }

    @Override
    public Object tabulate(int n1, int n2, Function2 f) {
        return IterableFactory.tabulate$(this, n1, n2, f);
    }

    @Override
    public Object tabulate(int n1, int n2, int n3, Function3 f) {
        return IterableFactory.tabulate$(this, n1, n2, n3, f);
    }

    @Override
    public Object tabulate(int n1, int n2, int n3, int n4, Function4 f) {
        return IterableFactory.tabulate$(this, n1, n2, n3, n4, f);
    }

    @Override
    public Object tabulate(int n1, int n2, int n3, int n4, int n5, Function5 f) {
        return IterableFactory.tabulate$(this, n1, n2, n3, n4, n5, f);
    }

    @Override
    public <A> Factory<A, ArrayBuffer<A>> iterableFactory() {
        return IterableFactory.iterableFactory$(this);
    }

    @Override
    public final SeqOps unapplySeq(SeqOps x) {
        return SeqFactory.unapplySeq$(this, x);
    }

    @Override
    public SeqOps fill(int n, Function0 elem) {
        return StrictOptimizedSeqFactory.fill$(this, n, elem);
    }

    @Override
    public SeqOps tabulate(int n, Function1 f) {
        return StrictOptimizedSeqFactory.tabulate$(this, n, f);
    }

    @Override
    public SeqOps concat(Seq xss) {
        return StrictOptimizedSeqFactory.concat$(this, xss);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArrayBuffer$.class);
    }

    public final int DefaultInitialSize() {
        return 16;
    }

    @Override
    public <B> ArrayBuffer<B> from(IterableOnce<B> coll) {
        int k = coll.knownSize();
        if (k >= 0) {
            Object[] array = this.scala$collection$mutable$ArrayBuffer$$$ensureSize(emptyArray, 0, k);
            int actual = IterableOnce$.MODULE$.copyElemsToArray(coll, array, IterableOnce$.MODULE$.copyElemsToArray$default$3(), IterableOnce$.MODULE$.copyElemsToArray$default$4());
            if (actual != k) {
                throw new IllegalStateException("Copied " + actual + " of " + k);
            }
            return new ArrayBuffer(array, k);
        }
        return (ArrayBuffer)new ArrayBuffer().$plus$plus$eq((IterableOnce)coll);
    }

    @Override
    public <A> Builder<A, ArrayBuffer<A>> newBuilder() {
        return new GrowableBuilder<A, ArrayBuffer<A>>(){

            public void sizeHint(int size) {
                ((ArrayBuffer)this.elems()).sizeHint(size);
            }
        };
    }

    @Override
    public <A> ArrayBuffer<A> empty() {
        return new ArrayBuffer();
    }

    public int resizeUp(int arrayLen, int targetLen) {
        if (targetLen < 0) {
            throw new RuntimeException("Overflow while resizing array of array-backed collection. Requested length: " + targetLen + "; current length: " + arrayLen + "; increase: " + (targetLen - arrayLen));
        }
        if (targetLen <= arrayLen) {
            return -1;
        }
        if (targetLen > 0x7FFFFFF7) {
            throw new RuntimeException("Array of array-backed collection exceeds VM length limit of " + 0x7FFFFFF7 + ". Requested length: " + targetLen + "; current length: " + arrayLen);
        }
        if (arrayLen > 0x3FFFFFFB) {
            return 0x7FFFFFF7;
        }
        return package$.MODULE$.max(targetLen, package$.MODULE$.max(arrayLen * 2, 16));
    }

    public Object[] scala$collection$mutable$ArrayBuffer$$$ensureSize(Object[] array, int curSize, int targetSize) {
        int newLen = this.resizeUp(array.length, targetSize);
        if (newLen < 0) {
            return array;
        }
        Object[] res = new Object[newLen];
        System.arraycopy(array, 0, res, 0, curSize);
        return res;
    }

    private int resizeDown(int arrayLen, int targetLen) {
        if (targetLen >= arrayLen) {
            return -1;
        }
        return package$.MODULE$.max(targetLen, 0);
    }

    public Object[] scala$collection$mutable$ArrayBuffer$$$downsize(Object[] array, int targetSize) {
        int newLen = this.resizeDown(array.length, targetSize);
        if (newLen < 0) {
            return array;
        }
        if (newLen == 0) {
            return emptyArray;
        }
        Object[] res = new Object[newLen];
        System.arraycopy(array, 0, res, 0, targetSize);
        return res;
    }
}

