/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.MetricsRecorder;
import com.google.api.gax.tracing.MetricsTracerFactory;
import com.google.api.gax.tracing.OpenTelemetryMetricsRecorder;
import com.google.cloud.firestore.telemetry.ClientIdentifier;
import com.google.cloud.firestore.telemetry.TelemetryConstants;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class BuiltinMetricsProvider {
    private static final Logger logger = Logger.getLogger(BuiltinMetricsProvider.class.getName());
    private OpenTelemetry openTelemetry;
    private DoubleHistogram endToEndLatency;
    private DoubleHistogram firstResponseLatency;
    private DoubleHistogram transactionLatency;
    private LongCounter transactionAttemptCount;
    private ApiTracerFactory apiTracerFactory;
    private final Map<String, String> staticAttributes;
    private static final String MILLISECOND_UNIT = "ms";
    private static final String INTEGER_UNIT = "1";
    private static final String FIRESTORE_LIBRARY_NAME = "com.google.cloud.firestore";

    public BuiltinMetricsProvider(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        this.staticAttributes = this.createStaticAttributes();
        if (openTelemetry.getMeterProvider() != MeterProvider.noop()) {
            this.configureRPCLayerMetrics();
            this.configureSDKLayerMetrics();
        }
    }

    private Map<String, String> createStaticAttributes() {
        HashMap<String, String> staticAttributes = new HashMap<String, String>();
        staticAttributes.put(TelemetryConstants.METRIC_ATTRIBUTE_KEY_CLIENT_UID.getKey(), ClientIdentifier.getClientUid());
        staticAttributes.put(TelemetryConstants.METRIC_ATTRIBUTE_KEY_LIBRARY_NAME.getKey(), FIRESTORE_LIBRARY_NAME);
        String pkgVersion = this.getClass().getPackage().getImplementationVersion();
        if (pkgVersion != null) {
            staticAttributes.put(TelemetryConstants.METRIC_ATTRIBUTE_KEY_LIBRARY_VERSION.getKey(), pkgVersion);
        }
        return staticAttributes;
    }

    private void configureRPCLayerMetrics() {
        OpenTelemetryMetricsRecorder recorder = new OpenTelemetryMetricsRecorder(this.openTelemetry, "custom.googleapis.com/internal/client");
        this.apiTracerFactory = new MetricsTracerFactory((MetricsRecorder)recorder, this.staticAttributes);
    }

    private void configureSDKLayerMetrics() {
        Meter meter = this.openTelemetry.getMeter("java_firestore");
        this.endToEndLatency = meter.histogramBuilder("custom.googleapis.com/internal/client/end_to_end_latency").setDescription("Firestore operations' end-to-end latency").setUnit(MILLISECOND_UNIT).build();
        this.firstResponseLatency = meter.histogramBuilder("custom.googleapis.com/internal/client/first_response_latency").setDescription("Firestore streaming operations' first response latency").setUnit(MILLISECOND_UNIT).build();
        this.transactionLatency = meter.histogramBuilder("custom.googleapis.com/internal/client/transaction_latency").setDescription("Firestore transactions' end-to-end latency").setUnit(MILLISECOND_UNIT).build();
        this.transactionAttemptCount = meter.counterBuilder("custom.googleapis.com/internal/client/transaction_attempt_count").setDescription("Number of Firestore transaction attempts including retries").setUnit(INTEGER_UNIT).build();
    }

    public ApiTracerFactory getApiTracerFactory() {
        return this.apiTracerFactory;
    }

    public void latencyRecorder(TelemetryConstants.MetricType metricType, double latency, Map<String, String> attributes) {
        DoubleHistogram histogram = this.getHistogram(metricType);
        if (histogram != null) {
            attributes.putAll(this.staticAttributes);
            try {
                histogram.record(latency, this.toOtelAttributes(attributes));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to record latency metric: " + e.getMessage(), e);
            }
        }
    }

    public void counterRecorder(TelemetryConstants.MetricType metricType, long count, Map<String, String> attributes) {
        LongCounter counter = this.getCounter(metricType);
        if (counter != null) {
            attributes.putAll(this.staticAttributes);
            try {
                counter.add(count, this.toOtelAttributes(attributes));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to record counter metric:" + e.getMessage(), e);
            }
        }
    }

    public DoubleHistogram getHistogram(TelemetryConstants.MetricType metricType) {
        switch (metricType) {
            case END_TO_END_LATENCY: {
                return this.endToEndLatency;
            }
            case FIRST_RESPONSE_LATENCY: {
                return this.firstResponseLatency;
            }
            case TRANSACTION_LATENCY: {
                return this.transactionLatency;
            }
        }
        throw new IllegalArgumentException("Unknown latency MetricType: " + (Object)((Object)metricType));
    }

    public LongCounter getCounter(TelemetryConstants.MetricType metricType) {
        if (metricType == TelemetryConstants.MetricType.TRANSACTION_ATTEMPT_COUNT) {
            return this.transactionAttemptCount;
        }
        throw new IllegalArgumentException("Unknown counter MetricType: " + (Object)((Object)metricType));
    }

    private Attributes toOtelAttributes(Map<String, String> attributes) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder.build();
    }
}

