<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used during authentication for various
    | messages that we need to display to the user. You are free to modify
    | these language lines according to your application's requirements.
    |
    */

    'failed' => 'These credentials do not match our records.',
    'throttle' => 'Too many login attempts. Please try again in :seconds seconds.',
    'not_authorized' => 'You are not authorized to execute this action',
    'signup_disabled' => 'Registration is currently disabled',
    'signup_error' => 'An error occured trying to register the user',
    'back_homepage' => 'Gå til startside',
    'mfa_auth_otp' => 'Authenticate with your two factor device',
    'mfa_auth_webauthn' => 'Authenticate with a security key (WebAuthn)',
    '2fa_title' => 'Two Factor Authentication',
    '2fa_wrong_validation' => 'The two factor authentication has failed.',
    '2fa_one_time_password' => 'Two factor authentication code',
    '2fa_recuperation_code' => 'Enter a two factor recovery code',
    '2fa_one_time_or_recuperation' => 'Enter a two factor authentication code or a recovery code',
    '2fa_otp_help' => 'Open up your two factor authentication mobile app and copy the code',

    'login_to_account' => 'Login to your account',
    'login_with_recovery' => 'Login with a recovery code',
    'login_again' => 'Please login again to your account',
    'email' => 'E-mail',
    'password' => 'Adgangskode',
    'recovery' => 'Gendannelseskode',
    'login' => 'Log ind',
    'button_remember' => 'Husk mig',
    'password_forget' => 'Glemt adgangskode?',
    'password_reset' => 'Nulstil din adgangskode',
    'use_recovery' => 'Or you can use a <a href=":url">recovery code</a>',
    'signup_no_account' => 'Har du ikke en bruger?',
    'signup' => 'Tilmeld dig',
    'create_account' => 'Create the first account by <a href=":url">signing up</a>',
    'change_language_title' => 'Skift sprog:',
    'change_language' => 'Skift sprog til :lang',

    'password_reset_title' => 'Nulstil adgangskode',
    'password_reset_email' => 'E-mail adresse',
    'password_reset_send_link' => 'Send Password Reset Link',
    'password_reset_password' => 'Adgangskode',
    'password_reset_password_confirm' => 'Bekræft adgangskode',
    'password_reset_action' => 'Nulstil adgangskode',
    'password_reset_email_content' => 'Klik her for at ændre din adgangskode:',

    'register_title_welcome' => 'Welcome to your newly installed Monica instance',
    'register_create_account' => 'You need to create an account to use Monica',
    'register_title_create' => 'Create your Monica account',
    'register_login' => '<a href=":url">Log in</a> if you already have an account.',
    'register_email' => 'Indtast en gyldig e-mail adresse',
    'register_email_example' => 'you@home',
    'register_firstname' => 'Fornavn',
    'register_firstname_example' => 'eg. John',
    'register_lastname' => 'Efternavn',
    'register_lastname_example' => 'eg. Doe',
    'register_password' => 'Kodeord',
    'register_password_example' => 'Enter a secure password',
    'register_password_confirmation' => 'Password confirmation',
    'register_action' => 'Registrér',
    'register_policy' => 'Signing up signifies you’ve read and agree to our <a href=":url" hreflang=":hreflang">Privacy Policy</a> and <a href=":urlterm" hreflang=":hreflang">Terms of use</a>.',
    'register_invitation_email' => 'For security purposes, please indicate the email of the person who’ve invited you to join this account. This information is provided in the invitation email.',

    'confirmation_title' => 'Bekræft din e-mail adresse',
    'confirmation_fresh' => 'A fresh verification link has been sent to your email address.',
    'confirmation_check' => 'Before proceeding, please check your email for a verification link.',
    'confirmation_request_another' => 'If you did not receive the email <a :action>click here to request another</a>.',

    'confirmation_again' => 'If you want to change your email address you can <a href=":url" class="alert-link">click here</a>.',
    'email_change_current_email' => 'Nuværende e-mail adresse:',
    'email_change_title' => 'Skift din e-mail adresse',
    'email_change_new' => 'Ny e-mail adresse',
    'email_changed' => 'Your email address has been changed. Check your mailbox to validate it.',
];
