"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertFieldCapsToMappingStructure = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const convertFieldCapsToMappingStructure = fieldCapsResponse => {
  let mappings = {};
  fieldCapsResponse.indices.forEach(index => {
    mappings[index] = {
      mappings: {
        properties: {}
      }
    };
  });
  for (const [fieldName, fieldDetails] of Object.entries(fieldCapsResponse.fields)) {
    if (fieldName.startsWith('_')) {
      continue;
    }
    for (const [fieldType, typeDetails] of Object.entries(fieldDetails)) {
      if (fieldType == 'unmapped') {
        continue;
      }
      let mapped_indices = _lodash.default.get(typeDetails, 'indices', fieldCapsResponse.indices);
      mapped_indices.forEach(mappedIndex => {
        mappings[mappedIndex]['mappings']['properties'][fieldName] = {
          type: typeDetails.type
        };
      });
    }
  }
  return mappings;
};
exports.convertFieldCapsToMappingStructure = convertFieldCapsToMappingStructure;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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