"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerObservabilityUISettings = void 0;
var _i18n = require("@osd/i18n");
var _configSchema = require("@osd/config-schema");
var _trace_analytics = require("../../common/constants/trace_analytics");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const registerObservabilityUISettings = uiSettings => {
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_SPAN_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomSpanIndices.name', {
        defaultMessage: 'Trace analytics custom span indices'
      }),
      value: '',
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomSpanIndices.description', {
        defaultMessage: '<strong>Experimental feature:</strong> Configure custom span indices that adhere to data prepper schema, to be used by the trace analytics plugin'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_SERVICE_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomServiceIndices.name', {
        defaultMessage: 'Trace analytics custom service indices'
      }),
      value: '',
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomServiceIndices.description', {
        defaultMessage: '<strong>Experimental feature:</strong> Configure custom service indices that adhere to data prepper schema, to be used by the trace analytics plugin'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_MODE_DEFAULT_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomModeDefault.name', {
        defaultMessage: 'Trace analytics custom mode default'
      }),
      value: false,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomModeDefault.description', {
        defaultMessage: '<strong>Experimental feature:</strong> Enable this to default to "custom_data_prepper" mode in the trace analytics plugin'
      }),
      schema: _configSchema.schema.boolean()
    }
  });
};
exports.registerObservabilityUISettings = registerObservabilityUISettings;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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