'\"
'\" Generated from file 'treeql\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Colin McCormack <coldstore@users\&.sourceforge\&.net>
'\" Copyright (c) 2004 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "treeql" n 1\&.3\&.2 tcllib "Tree Query Language"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
treeql \- Query tree objects
.SH SYNOPSIS
package require \fBTcl 8\&.5 9\fR
.sp
package require \fBsnit\fR
.sp
package require \fBstruct::list\fR
.sp
package require \fBstruct::set\fR
.sp
package require \fBtreeql ?1\&.3\&.2?\fR
.sp
\fBtreeql\fR \fIobjectname\fR \fB-tree\fR \fItree\fR ?\fB-query\fR \fIquery\fR? ?\fB-nodes\fR \fInodes\fR? ?\fIargs\fR\&.\&.\&.?
.sp
\fIqo\fR \fBquery\fR \fIargs\fR\&.\&.\&.
.sp
\fIqo\fR \fBresult\fR
.sp
\fIqo\fR \fBdiscard\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides objects which can be used to query and transform
tree objects following the API of tree objects created by the package
\fBstruct::tree\fR\&.
.PP
The tree query and manipulation language used here, TreeQL, is
inspired by Cost (See section \fBReferences\fR for more
information)\&.
.PP
\fBtreeql\fR, the package, is a fairly thin query facility over
tree-structured data types\&.  It implements an ordered set of nodes
(really a list) which are generated and filtered through the
application of TreeQL operators to each node in turn\&.
.SH API
.SS "TREEQL CLASS API"
The command \fBtreeql\fR is a \fBsnit\fR::type which implements
the Treeql Query Language\&. This means that it follows the API for
class commands as specified by the package \fBsnit\fR\&.
Its general syntax is
.TP
\fBtreeql\fR \fIobjectname\fR \fB-tree\fR \fItree\fR ?\fB-query\fR \fIquery\fR? ?\fB-nodes\fR \fInodes\fR? ?\fIargs\fR\&.\&.\&.?
The command creates a new tree query object and returns the fully
qualified name of the object command as its result\&.
The API the returned command is following is described in the section
\fBTreeQL OBJECT API\fR
.sp
Each query object is associated with a single \fItree\fR object\&. This
is the object all queries will be run against\&.
.sp
If the option \fB-nodes\fR was specified then its argument is
treated as a list of nodes\&. This list is used to initialize the node
set\&. It defaults to the empty list\&.
.sp
If the option \fB-query\fR was specified then its argument will be
interpreted as an object, the \fIparent query\fR of this query\&. It
defaults to the object itself\&. All queries will be interpreted in the
environment of this object\&.
.sp
Any arguments coming after the options are treated as a query and run
immediately, after the \fInode set\fR has been initialized\&. This
uses the same syntax for the query as the method \fBquery\fR\&.
.sp
The operations of the TreeQL available for this are explained in the
section about \fBThe Tree Query Language\fR\&. This section also
explains the term \fInode set\fR used above\&.
.PP
.SS "TREEQL OBJECT API"
As \fBtreeql\fR has been implemented in \fBsnit\fR all the
standard methods of \fBsnit\fR-based classes are available to the
user and therefore not listed here\&. Please read the documentation for
\fBsnit\fR for what they are and what functionality they provide
.PP
The methods provided by the package \fBtreeql\fR itself are listed
and explained below\&.
.TP
\fIqo\fR \fBquery\fR \fIargs\fR\&.\&.\&.
This method interprets its arguments as a series of TreeQL operators
and interpretes them from the left to right (i\&.e\&. first to last)\&.
Note that the first operator uses the \fInode set\fR currently
known to the object to perform its actions\&.
In other words, the \fInode set\fR is \fInot\fR cleared, or
modified in other ways, before the query is run\&. This allows the user
to run several queries one after the other and have each use the
results of the last\&. Any initialization has to be done by any query
itself, using TreeQL operators\&.
The result of the method is the \fInode set\fR after the last
operator of the query has been executed\&.
.sp
\fINote\fR that uncaught errors will leave the \fInode set\fR of
the object in an intermediate state, per the TreeQL operators which
were executed successfully before the error occurred\&.
.sp
The above means in detail that:
.RS
.IP [1]
The first argument is interpreted as the name of a query operator, the
number of arguments required by that operator is then determined, and
taken from the immediately following arguments\&.
.sp
Because of this operators cannot have optional arguments, all
arguments have to be present as defined\&.  Failure to do this will, at
least, confuse the query interpreter, but more likely cause errors\&.
.IP [2]
The operator is applied to the current node set, yielding a new node
set, and/or manipulating the tree object the query object is connected
to\&.
.IP [3]
The arguments used (i\&.e\&. operator name and arguments) are removed from
the list of method arguments, and then the whole process is repeated
from step [1], until the list of arguments is empty or an error
occurred\&.
.RE
.sp
.CS


    # q is the query object\&.

    q query root children get data

    # The above query
    # - Resets the node set to the root node - root
    # - Adds the children of root to the set - children
    # - Replaces the node set with the       - get data
    #   values for the attribute 'data',
    #   for all nodes in the set which
    #   have such an attribute\&.
    # - And returns this information\&.

    # Below we can see the same query, but rewritten
    # to show the structure as it is seen by the query
    # interpreter\&.

    q query \\
	    root \\
	    children \\
	    get data

.CE
.sp
The operators of the TreeQL language available for this are explained
in the section about \fBThe Tree Query Language\fR\&. This section
also explains the term \fInode set\fR used above\&.
.TP
\fIqo\fR \fBresult\fR
This method returns a list containing the current node set\&.
.TP
\fIqo\fR \fBdiscard\fR
This method returns the current node set (like method
\fBresult\fR), but also destroys the query object (\fIqo\fR)\&.
This is useful when constructing and using sub-queries (%AUTO% objects
immediately destroyed after use)\&.
.PP
.SH "THE TREE QUERY LANGUAGE"
This and the following sections specify the Tree Query Language used
by the query objects of this package in detail\&.
.PP
First we explain the general concepts underneath the language which
are required to comprehend it\&. This is followed by the specifications
for all the available query operators\&. They fall into eight
categories, and each category has its own section\&.
.PP
.IP [1]
\fBTreeQL Concepts\fR
.IP [2]
\fBStructural generators\fR
.IP [3]
\fBAttribute Filters\fR
.IP [4]
\fBAttribute Mutators\fR
.IP [5]
\fBAttribute String Accessors\fR
.IP [6]
\fBSub-queries\fR
.IP [7]
\fBNode Set Operators\fR
.IP [8]
\fBNode Set Iterators\fR
.IP [9]
\fBTyped node support\fR
.PP
.PP
.SS "TREEQL CONCEPTS"
The main concept which has to be understood is that of the
\fInode set\fR\&.
Each query object maintains exactly one such \fInode set\fR, and
essentially all operators use it and input argument and for their
result\&.
This structure simply contains the handles of all nodes which are
currently of interest to the query object\&.
To name it a \fIset\fR is a bit of a misnomer, because
.IP [1]
A node (handle) can occur in the structure more than once, and
.IP [2]
the order of nodes in the structure is important as well\&.
Whenever an operator processes all nodes in the node set it will do so
in the order they occur in the structure\&.
.PP
.PP
Regarding the possible multiple occurrence of a node, consider a node
set containing two nodes A and B, both having node P as their
immediate parent\&. Application of the TreeQL operator "parent" will
then add P to the new node set twice, once per node it was parent
of\&. I\&.e\&. the new node set will then be {P P}\&.
.SS "STRUCTURAL GENERATORS"
All tree-structural operators locate nodes in the tree based on a
structural relation ship to the nodes currently in the set and then
replace the current node set with the set of nodes found
Nodes which fulfill such a relationship multiple times are added to
the result as often as they fulfill the relationship\&.
.PP
It is important to note that the found nodes are collected in a
separate storage area while processing the node set, and are added to
(or replacing) the current node set only after the current node set
has been processed completely\&.
In other words, the new nodes are \fInot\fR processed by the operator
as well and do not affect the iteration\&.
.PP
When describing an operator the variable \fBN\fR will be used to refer
to any node in the node set\&.
.TP
\fBancestors\fR
Replaces the current node set with the ancestors for all nodes \fBN\fR
in the node set, should \fBN\fR have a parent\&. In other words, nodes
without a parent do not contribute to the new node set\&. In other
words, uses all nodes on the path from node \fBN\fR to root, in this
order (root last), for all nodes \fBN\fR in the node set\&. This
includes the root, but not the node itself\&.
.TP
\fBrootpath\fR
Replaces the current node set with the ancestors for all nodes \fBN\fR
in the node set, should \fBN\fR have a parent\&. In other words, nodes
without a parent do not contribute to the new node set\&.
In contrast to the operator \fBancestors\fR the nodes are added in
reverse order however, i\&.e\&. the root node first\&.
.TP
\fBparent\fR
Replaces the current node set with the parent of node \fBN\fR, for all
nodes \fBN\fR in the node set, should \fBN\fR have a parent\&. In other
words, nodes without a parent do not contribute to the new node set\&.
.TP
\fBchildren\fR
Replaces the current node set with the immediate children of node
\fBN\fR, for all nodes \fBN\fR in the node set, should \fBN\fR have
children\&. In other words, nodes without children do not contribute to
the new node set\&.
.TP
\fBleft\fR
Replaces the current node set with the previous/left sibling for all
nodes \fBN\fR in the node set, should \fBN\fR have siblings to the
left\&. In other words, nodes without left siblings do not contribute to
the new node set\&.
.TP
\fBright\fR
Replaces the current node set with the next/right sibling for all
nodes \fBN\fR in the node set, should \fBN\fR have siblings to the
right\&. In other words, nodes without right siblings do not contribute
to the new node set\&.
.TP
\fBprev\fR
Replaces the current node set with all previous/left siblings of node
\fBN\fR, for all nodes \fBN\fR in the node set, should \fBN\fR have
siblings to the left\&. In other words, nodes without left siblings are
ignored\&. The left sibling adjacent to the node is added first, and the
leftmost sibling last (reverse tree order)\&.
.TP
\fBesib\fR
Replaces the current node set with all previous/left siblings of node
\fBN\fR, for all nodes \fBN\fR in the node set, should \fBN\fR have
siblings to the left\&. In other words, nodes without left siblings are
ignored\&. The leftmost sibling is added first, and the left sibling
adjacent to the node last (tree order)\&.
.sp
The method name is a shorthand for \fIEarlier SIBling\fR\&.
.TP
\fBnext\fR
Replaces the current node set with all next/right siblings of node
\fBN\fR, for all nodes \fBN\fR in the node set, should \fBN\fR have
siblings to the right\&. In other words, nodes without right siblings do
not contribute to the new node set\&. The right sibling adjacent to the
node is added first, and the rightmost sibling last (tree order)\&.
.TP
\fBroot\fR
Replaces the current node set with a node set containing a single
node, the root of the tree\&.
.TP
\fBtree\fR
Replaces the current node set with a node set containing all nodes
found in the tree\&. The nodes are added in pre-order (parent first,
then children, the latter from left to right, first to last)\&.
.TP
\fBdescendants\fR
Replaces the current node set with the nodes in all subtrees rooted at
node \fBN\fR, for all nodes \fBN\fR in the node set, should \fBN\fR
have children\&. In other words, nodes without children do not
contribute to the new node set\&.
.sp
This is like the operator \fBchildren\fR, but covers the children
of children as well, i\&.e\&. all the \fIproper descendants\fR\&. "Rooted
at \fBN\fR" means that \fBN\fR itself is not added to the new set,
which is also implied by \fIproper descendants\fR\&.
.TP
\fBsubtree\fR
Like operator \fBdescendants\fR, but includes the node \fBN\fR\&. In
other words:
.sp
Replaces the current node set with the nodes of the subtree of node
\fBN\fR, for all nodes \fBN\fR in the node set, should \fBN\fR have
children\&. In other words, nodes without children do not contribute to
the new node set\&. I\&.e this is like the operator \fBchildren\fR, but
covers the children of children, etc\&. as well\&. "Of \fBN\fR" means that
\fBN\fR itself is added to the new set\&.
.TP
\fBforward\fR
Replaces the current node set with the nodes in the subtrees rooted at
the right siblings of node \fBN\fR, for all nodes \fBN\fR in the node
set, should \fBN\fR have right siblings, and they children\&. In other
words, nodes without right siblings, and them without children are
ignored\&.
.sp
This is equivalent to the operator sequence
.CS

next descendants
.CE
.TP
\fBlater\fR
This is an alias for the operator \fBforward\fR\&.
.TP
\fBbackward\fR
Replaces the current node set with the nodes in the flattened previous
subtrees, in reverse tree order\&.
.sp
This is nearly equivalent to the operator sequence
.CS

prev descendants
.CE
.IP
The only difference is that this uses the nodes in reverse order\&.
.TP
\fBearlier\fR
Replaces the current node set with the nodes in the flattened previous
subtrees, in tree order\&.
.sp
This is equivalent to the operator sequence
.CS

prev subtree
.CE
.PP
.SS "ATTRIBUTE FILTERS"
These operators filter the node set by reference to attributes of
nodes and their properties\&. Filter means that all nodes not fulfilling
the criteria are removed from the node set\&. In other words, the node
set is replaced by the set of nodes fulfilling the filter criteria\&.
.TP
\fBhasatt\fR \fIattr\fR
Reduces the node set to nodes which have an attribute named
\fIattr\fR\&.
.TP
\fBwithatt\fR \fIattr\fR \fIvalue\fR
Reduces the node set to nodes which have an attribute named
\fIattr\fR, and where the value of that attribute is equal to
\fIvalue\fR (The "==" operator is \fBstring equal -nocase\fR)\&.
.TP
\fBwithatt!\fR \fIattr\fR \fIval\fR
This is the same as \fBwithatt\fR, but all nodes in the node set
have to have the attribute, and the "==" operator is
\fBstring equal\fR, i\&.e\&. no \fB-nocase\fR\&.
The operator will fail with an error if they don't have the attribute\&.
.TP
\fBattof\fR \fIattr\fR \fIvals\fR
Reduces the node set to nodes which which have an attribute named
\fIattr\fR and where the value of that attribute is contained in the
list \fIvals\fR of legal values\&. The contained-in operator used here
does glob matching (using the attribute value as pattern) and ignores
the case of the attribute value, \fIbut not\fR for the elements of
\fIvals\fR\&.
.TP
\fBattmatch\fR \fIattr\fR \fImatch\fR
Same as \fBwithatt\fR, but \fBstring match\fR is used as the "=="
operator, and \fImatch\fR is the pattern checked for\&.
.sp
\fINote\fR that \fImatch\fR is a interpreted as a partial argument
\fIlist\fR for \fBstring match\fR\&. This means that it is
interpreted as a list containing the pattern, and the pattern element
can be preceded by options understand by \fBstring match\fR, like
\fB-nocase\fR\&.
This is especially important should the pattern contain spaces\&. It has
to be wrapped into a list for correct interpretation by this operator
.PP
.SS "ATTRIBUTE MUTATORS"
These operators change node attributes within the underlying tree\&. In
other words, all these operators have \fIside effects\fR\&.
.TP
\fBset\fR \fIattr\fR \fIval\fR
Sets the attribute \fIattr\fR to the value \fIval\fR, for all nodes
\fBN\fR in the node set\&.
The operator will fail if a node does not have an attribute named
\fIattr\fR\&. The tree will be left in a partially modified state\&.
.TP
\fBunset\fR \fIattr\fR
Unsets the attribute \fIattr\fR, for all nodes \fBN\fR in the node
set\&.
The operator will fail if a node does not have an attribute named
\fIattr\fR\&. The tree will be left in a partially modified state\&.
.PP
.SS "ATTRIBUTE STRING ACCESSORS"
These operators retrieve the values of node attributes from the
underlying tree\&. The collected results are stored in the node set, but
are not actually nodes\&.
.PP
In other words, they redefine the semantics of the node set stored by
the query object to contain non-node data after their completion\&.
.PP
The query interpreter will terminate after it has finished processing
one of these operators, silently discarding any later query elements\&.
It also means that our talk about maintenance of a node set is not
quite true\&. It is a node set while the interpreter is processing
commands, but can be left as an attribute value set at the end of
query processing\&.
.TP
\fBstring\fR \fIop\fR \fIattr\fR
Applies the string operator \fIop\fR to the attribute named
\fIattr\fR, for all nodes \fBN\fR in the node set, collects the
results of that application and places them into the node set\&.
.sp
The operator will fail if a node does not have an attribute named
\fIattr\fR\&.
.sp
The argument \fIop\fR is interpreted as partial argument list for the
builtin command \fBstring\fR\&.  Its first word has to be any of the
sub-commands understood by \fBstring\fR\&.  This has to be followed by
all arguments required for the subcommand, except the last\&.  that last
argument is supplied by the attribute value\&.
.TP
\fBget\fR \fIpattern\fR
For all nodes \fBN\fR in the node set it determines all their
attributes with names matching the glob \fIpattern\fR, then the values
of these attributes, at last it replaces the node set with the list of
these attribute values\&.
.TP
\fBattlist\fR
This is a convenience definition for the operator
\fBgetvals *\fR\&. In other words, it replaces the node set with a
list of the attribute values for all attributes for all nodes \fBN\fR
in the node set\&.
.TP
\fBattrs\fR \fIglob\fR
Replaces the current node set with a list of attribute lists, one
attribute list per for all nodes \fBN\fR in the node set\&.
.TP
\fBattval\fR \fIattname\fR
Reduces the current node set with the operator \fBhasatt\fR, and
then replaces it with a list containing the values of the attribute
named \fIattname\fR for all nodes \fBN\fR in the node set\&.
.PP
.SS SUB-QUERIES
Sub-queries yield node sets which are then used to augment, reduce or
replace the current node set\&.
.TP
\fBandq\fR \fIquery\fR
Replaces the node set with the set-intersection of the node set
generated by the sub-query \fIquery\fR and itself\&.
.sp
The execution of the sub-query uses the current node set as its own
initial node set\&.
.TP
\fBorq\fR \fIquery\fR
Replaces the node set with the set-union of the node set generated by
the sub-query \fIquery\fR and itself\&. Duplicate nodes are removed\&.
.sp
The execution of the sub-query uses the current node set as its own
initial node set\&.
.TP
\fBnotq\fR \fIquery\fR
Replaces the node set with the set of nodes generated by the sub-query
\fIquery\fR which are also not in the current node set\&. In other word
the set difference of itself and the node set generated by the
sub-query\&.
.sp
The execution of the sub-query uses the current node set as its own
initial node set\&.
.PP
.SS "NODE SET OPERATORS"
These operators change the node set directly, without referring to the
tree\&.
.TP
\fBunique\fR
Removes duplicate nodes from the node set, preserving order\&. In other
words, the earliest occurrence of a node handle is preserved, every
other occurrence is removed\&.
.TP
\fBselect\fR
Replaces the current node set with a node set containing only the
first node from the current node set
.TP
\fBtransform\fR \fIquery\fR \fIvar\fR \fIbody\fR
First it interprets the sub-query \fIquery\fR, using the current node
set as its initial node set\&.
Then it iterates over the result of that query, binding the handle of
each node to the variable named in \fIvar\fR, and executing the script
\fIbody\fR\&.
The collected results of these executions is made the new node set,
replacing the current one\&.
.sp
The script \fIbody\fR is executed in the context of the caller\&.
.TP
\fBmap\fR \fIvar\fR \fIbody\fR
Iterates over the current node set, binding the handle of each node to
the variable named in \fIvar\fR, and executing the script \fIbody\fR\&.
The collected results of these executions is made the new node set,
replacing the current one\&.
.sp
The script \fIbody\fR is executed in the context of the caller\&.
.TP
\fBquote\fR \fIval\fR
Appends the literal value \fIval\fR to the current node set\&.
.TP
\fBreplace\fR \fIval\fR
Replaces the current node set with the literal list value \fIval\fR\&.
.PP
.SS "NODE SET ITERATORS"
.TP
\fBforeach\fR \fIquery\fR \fIvar\fR \fIbody\fR
Interprets the sub-query \fIquery\fR, then performs the equivalent of
operator \fBover\fR on the nodes in the node set created by that
query\&. The current node set is not changed, except through side
effects from the script \fIbody\fR\&.
.sp
The script \fIbody\fR is executed in the context of the caller\&.
.TP
\fBwith\fR \fIquery\fR \fIbody\fR
Interprets the \fIquery\fR, then runs the script \fIbody\fR on the
node set generated by the query\&. At last it restores the current node
set as it was before the execution of the query\&.
.sp
The script \fIbody\fR is executed in the context of the caller\&.
.TP
\fBover\fR \fIvar\fR \fIbody\fR
Executes the script \fIbody\fR for each node in the node set, with the
variable named by \fIvar\fR bound to the name of the current node\&.
The script \fIbody\fR is executed in the context of the caller\&.
.sp
This is like the builtin \fBforeach\fR, with the node set as the
source of the list to iterate over\&.
.sp
The results of executing the \fIbody\fR are ignored\&.
.TP
\fBdelete\fR
Deletes all the nodes contained in the current node set from the tree\&.
.PP
.SS "TYPED NODE SUPPORT"
These filters and accessors assume the existence of an attribute
called \fB@type\fR, and are short-hand forms useful for cost-like
tree query, html tree editing, and so on\&.
.TP
\fBnodetype\fR
Returns the node type of nodes\&.
Attribute string accessor\&. This is equivalent to
.CS

get @type
.CE
.TP
\fBoftype\fR \fIt\fR
Reduces the node set to nodes whose type is equal to \fIt\fR, with
letter case ignored\&.
.TP
\fBnottype\fR \fIt\fR
Reduces the node set to nodes whose type is not equal to \fIt\fR, with
letter case ignored\&.
.TP
\fBoftypes\fR \fIattrs\fR
Reduces set to nodes whose @type is an element in the list \fIattrs\fR
of types\&. The value of @type is used as a glob pattern, and letter
case is relevant\&.
.PP
.SH EXAMPLES
\&.\&.\&. TODO \&.\&.\&.
.SH REFERENCES
.IP [1]
\fICOST\fR [http://wiki\&.tcl\&.tk/COST] on the Tcler's Wiki\&.
.IP [2]
\fITreeQL\fR [http://wiki\&.tcl\&.tk/treeql] on the Tcler's Wiki\&. Discuss
this package there\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fItreeql\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
Cost, DOM, TreeQL, XPath, XSLT, structured queries, tree, tree query language
.SH CATEGORY
Data structures
.SH COPYRIGHT
.nf
Copyright (c) 2004 Colin McCormack <coldstore@users\&.sourceforge\&.net>
Copyright (c) 2004 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi
