/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TodoCommentCheck
extends AbstractFormatCheck {
    public TodoCommentCheck() {
        super("TODO:");
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void beginTree(DetailAST aRootAST) {
        FileContents contents = this.getFileContents();
        this.checkCppComments(contents);
        this.checkBadComments(contents);
    }

    private void checkCppComments(FileContents aContents) {
        Map comments = aContents.getCppComments();
        Iterator it = comments.keySet().iterator();
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            String cmt = (String)comments.get(key);
            if (!this.getRegexp().match(cmt)) continue;
            this.log((int)key, "todo.match", (Object)this.getFormat());
        }
    }

    private void checkBadComments(FileContents aContents) {
        Map allComments = aContents.getCComments();
        Iterator allIter = allComments.keySet().iterator();
        while (allIter.hasNext()) {
            Integer key = (Integer)allIter.next();
            List lineComments = (List)allComments.get(key);
            Iterator lineIter = lineComments.iterator();
            while (lineIter.hasNext()) {
                String[] cmt = (String[])lineIter.next();
                int i = 0;
                while (i < cmt.length) {
                    if (this.getRegexp().match(cmt[i])) {
                        this.log(key + i, "todo.match", (Object)this.getFormat());
                    }
                    ++i;
                }
            }
        }
    }
}

