untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT3kReh6/cjCR/7pax79ZCqq0gf4Hc3+k2niDthH6uj+9rK5LNvzflWf54udoiHYotBCBvGd4xGMdI4LLAhOK4wk=

OpenBSD 6.5 errata 024, December 11, 2019:

ld.so may fail to remove the LD_LIBRARY_PATH environment variable for
set-user-ID and set-group-ID executables in low memory conditions.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 024_ldso.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install ld.so:
    cd /usr/src/libexec/ld.so
    make obj
    make
    make install

Index: libexec/ld.so/loader.c
===================================================================
RCS file: /cvs/src/libexec/ld.so/loader.c,v
diff -u -p -u -r1.177 loader.c
--- libexec/ld.so/loader.c	3 Dec 2018 05:29:56 -0000	1.177
+++ libexec/ld.so/loader.c	11 Dec 2019 17:06:10 -0000
@@ -213,13 +213,14 @@ char *__progname = NULL;
 void
 _dl_setup_env(const char *argv0, char **envp)
 {
+	char *libpath;
 	static char progname_storage[NAME_MAX+1] = "";
 
 	/*
 	 * Get paths to various things we are going to use.
 	 */
 	_dl_debug = _dl_getenv("LD_DEBUG", envp) != NULL;
-	_dl_libpath = _dl_split_path(_dl_getenv("LD_LIBRARY_PATH", envp));
+	libpath = _dl_getenv("LD_LIBRARY_PATH", envp);
 	_dl_preload = _dl_getenv("LD_PRELOAD", envp);
 	_dl_bindnow = _dl_getenv("LD_BIND_NOW", envp) != NULL;
 	_dl_traceld = _dl_getenv("LD_TRACE_LOADED_OBJECTS", envp) != NULL;
@@ -233,9 +234,8 @@ _dl_setup_env(const char *argv0, char **
 	 */
 	_dl_trust = !_dl_issetugid();
 	if (!_dl_trust) {	/* Zap paths if s[ug]id... */
-		if (_dl_libpath) {
-			_dl_free_path(_dl_libpath);
-			_dl_libpath = NULL;
+		if (libpath) {
+			libpath = NULL;
 			_dl_unsetenv("LD_LIBRARY_PATH", envp);
 		}
 		if (_dl_preload) {
@@ -251,6 +251,8 @@ _dl_setup_env(const char *argv0, char **
 			_dl_unsetenv("LD_DEBUG", envp);
 		}
 	}
+	if (libpath)
+		_dl_libpath = _dl_split_path(libpath);
 	environ = envp;
 
 	_dl_trace_setup(envp);
