untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQTyf/B7jK/PSfxorzTyhxg/UMb7NIsDrhAu5J5v0418bXj3LsdhjTxKdn5zx4AfE7nHQFnK6ngVemRP4gclvOmAk=

OpenBSD 6.5 errata 028, January 17, 2020:

Execution Unit state was not cleared on context switch with Intel Gen9
graphics hardware.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 028_inteldrmctx.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/pci/drm/i915/intel_lrc.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/i915/intel_lrc.c,v
retrieving revision 1.2
diff -u -p -r1.2 intel_lrc.c
--- sys/dev/pci/drm/i915/intel_lrc.c	30 Sep 2017 07:36:56 -0000	1.2
+++ sys/dev/pci/drm/i915/intel_lrc.c	15 Jan 2020 02:32:53 -0000
@@ -1313,6 +1313,7 @@ static int gen9_init_indirectctx_bb(stru
 	int ret;
 	struct drm_device *dev = ring->dev;
 	uint32_t index = wa_ctx_start(wa_ctx, *offset, CACHELINE_DWORDS);
+	uint32_t scratch_addr;
 
 	/* WaDisableCtxRestoreArbitration:skl,bxt */
 	if (IS_SKL_REVID(dev, 0, SKL_REVID_D0) ||
@@ -1324,6 +1325,19 @@ static int gen9_init_indirectctx_bb(stru
 	if (ret < 0)
 		return ret;
 	index = ret;
+
+	/* WaClearSlmSpaceAtContextSwitch:skl,bxt,kbl,glk,cfl */
+	/* Actual scratch location is at 128 bytes offset */
+	scratch_addr = ring->scratch.gtt_offset + 2 * CACHELINE_BYTES;
+	wa_ctx_emit(batch, index, GFX_OP_PIPE_CONTROL(6));
+	wa_ctx_emit(batch, index, (PIPE_CONTROL_FLUSH_L3 |
+				   PIPE_CONTROL_GLOBAL_GTT_IVB |
+				   PIPE_CONTROL_CS_STALL |
+				   PIPE_CONTROL_QW_WRITE));
+	wa_ctx_emit(batch, index, scratch_addr);
+	wa_ctx_emit(batch, index, 0);
+	wa_ctx_emit(batch, index, 0);
+	wa_ctx_emit(batch, index, 0);
 
 	/* Pad to end of cacheline */
 	while (index % CACHELINE_DWORDS)
