/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.annotation.Nullable;

class SerializedLambdaQueries {
    private static final String GENERATED_LAMBDA_CLASS_SUFFIX = "$$Lambda";

    SerializedLambdaQueries() {
    }

    public static boolean isLambdaClass(Class<?> type) {
        return type.isSynthetic() && SerializedLambdaQueries.isLambdaClassName(type.getName());
    }

    public static boolean isLambdaClassName(String className) {
        return className.contains(GENERATED_LAMBDA_CLASS_SUFFIX);
    }

    public static Optional<SerializedLambda> serializedLambdaFor(@Nullable Object lambda) {
        if (!(lambda instanceof Serializable)) {
            return Optional.empty();
        }
        for (Class<?> lambdaClass = lambda.getClass(); lambdaClass != null; lambdaClass = lambdaClass.getSuperclass()) {
            try {
                Method replaceMethod = lambdaClass.getDeclaredMethod("writeReplace", new Class[0]);
                replaceMethod.setAccessible(true);
                Object serializedForm = replaceMethod.invoke(lambda, new Object[0]);
                if (serializedForm instanceof SerializedLambda) {
                    return Optional.of((SerializedLambda)serializedForm);
                }
                return Optional.empty();
            }
            catch (NoSuchMethodException replaceMethod) {
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

