/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import java.util.ArrayList;
import java.util.List;

public class JNITypeParser {
    static final char SIGNATURE_ENDCLASS = ';';
    static final char SIGNATURE_FUNC = '(';
    static final char SIGNATURE_ENDFUNC = ')';
    private final String signature;
    private List<String> typeNameList;
    private List<String> signatureList;
    private int currentIndex;

    JNITypeParser(String signature) {
        this.signature = signature;
    }

    public static String typeNameToSignature(String typeName) {
        int firstIndex;
        StringBuilder sb = new StringBuilder();
        int index = firstIndex = typeName.indexOf(91);
        while (index != -1) {
            sb.append('[');
            index = typeName.indexOf(91, index + 1);
        }
        if (firstIndex != -1) {
            typeName = typeName.substring(0, firstIndex);
        }
        if (typeName.equals("boolean")) {
            sb.append('Z');
        } else if (typeName.equals("byte")) {
            sb.append('B');
        } else if (typeName.equals("char")) {
            sb.append('C');
        } else if (typeName.equals("short")) {
            sb.append('S');
        } else if (typeName.equals("int")) {
            sb.append('I');
        } else if (typeName.equals("long")) {
            sb.append('J');
        } else if (typeName.equals("float")) {
            sb.append('F');
        } else if (typeName.equals("double")) {
            sb.append('D');
        } else {
            sb.append('L');
            index = typeName.indexOf("/");
            if (index < 0) {
                sb.append(typeName.replace('.', '/'));
            } else {
                sb.append(typeName.substring(0, index).replace('.', '/'));
                sb.append(".");
                sb.append(typeName.substring(index + 1));
            }
            sb.append(';');
        }
        return sb.toString();
    }

    String typeName() {
        return this.typeNameList().get(this.typeNameList().size() - 1);
    }

    List<String> argumentTypeNames() {
        return this.typeNameList().subList(0, this.typeNameList().size() - 1);
    }

    String signature() {
        return this.signatureList().get(this.signatureList().size() - 1);
    }

    List<String> argumentSignatures() {
        return this.signatureList().subList(0, this.signatureList().size() - 1);
    }

    int dimensionCount() {
        int count = 0;
        String signature = this.signature();
        while (signature.charAt(count) == '[') {
            ++count;
        }
        return count;
    }

    byte jdwpTag() {
        return (byte)this.signature().charAt(0);
    }

    String componentSignature(int level) {
        assert (level <= this.dimensionCount());
        return this.signature().substring(level);
    }

    String componentSignature() {
        assert (this.isArray());
        return this.componentSignature(1);
    }

    boolean isArray() {
        return this.jdwpTag() == 91;
    }

    boolean isVoid() {
        return this.jdwpTag() == 86;
    }

    boolean isBoolean() {
        return this.jdwpTag() == 90;
    }

    boolean isReference() {
        byte tag = this.jdwpTag();
        return tag == 91 || tag == 76;
    }

    boolean isPrimitive() {
        switch (this.jdwpTag()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                return true;
            }
        }
        return false;
    }

    static String convertSignatureToClassname(String classSignature) {
        assert (classSignature.startsWith("L") && classSignature.endsWith(";"));
        String name = classSignature.substring(1, classSignature.length() - 1);
        int index = name.indexOf(".");
        if (index < 0) {
            return name.replace('/', '.');
        }
        return name.substring(0, index).replace('/', '.') + "/" + name.substring(index + 1);
    }

    private synchronized List<String> signatureList() {
        if (this.signatureList == null) {
            this.signatureList = new ArrayList<String>(10);
            this.currentIndex = 0;
            while (this.currentIndex < this.signature.length()) {
                String elem = this.nextSignature();
                this.signatureList.add(elem);
            }
            if (this.signatureList.size() == 0) {
                throw new IllegalArgumentException("Invalid JNI signature '" + this.signature + "'");
            }
        }
        return this.signatureList;
    }

    private synchronized List<String> typeNameList() {
        if (this.typeNameList == null) {
            this.typeNameList = new ArrayList<String>(10);
            this.currentIndex = 0;
            while (this.currentIndex < this.signature.length()) {
                String elem = this.nextTypeName();
                this.typeNameList.add(elem);
            }
            if (this.typeNameList.size() == 0) {
                throw new IllegalArgumentException("Invalid JNI signature '" + this.signature + "'");
            }
        }
        return this.typeNameList;
    }

    private String nextSignature() {
        char key = this.signature.charAt(this.currentIndex++);
        switch (key) {
            case '[': {
                return key + this.nextSignature();
            }
            case 'L': {
                int endClass = this.signature.indexOf(59, this.currentIndex);
                String retVal = this.signature.substring(this.currentIndex - 1, endClass + 1);
                this.currentIndex = endClass + 1;
                return retVal;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return String.valueOf(key);
            }
            case '(': 
            case ')': {
                return this.nextSignature();
            }
        }
        throw new IllegalArgumentException("Invalid JNI signature character '" + key + "'");
    }

    private String nextTypeName() {
        char key = this.signature.charAt(this.currentIndex++);
        switch (key) {
            case '[': {
                return this.nextTypeName() + "[]";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'L': {
                int endClass = this.signature.indexOf(59, this.currentIndex);
                Object retVal = this.signature.substring(this.currentIndex, endClass);
                int index = ((String)retVal).indexOf(".");
                retVal = index < 0 ? ((String)retVal).replace('/', '.') : ((String)retVal).substring(0, index).replace('/', '.') + "/" + ((String)retVal).substring(index + 1);
                this.currentIndex = endClass + 1;
                return retVal;
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case '(': 
            case ')': {
                return this.nextTypeName();
            }
        }
        throw new IllegalArgumentException("Invalid JNI signature character '" + key + "'");
    }
}

