/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ExpandMacroToPathMap
extends PathMacroMap {
    private final Map<String, String> myPlainMap = new LinkedHashMap<String, String>();
    private final Map<String, String> myMacroExpands = new HashMap<String, String>();

    @ApiStatus.Internal
    public ExpandMacroToPathMap() {
    }

    @ApiStatus.Internal
    public void addMacroExpand(@NotNull String macroName, @NotNull String path) {
        if (macroName == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(0);
        }
        if (path == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(1);
        }
        this.myMacroExpands.put(macroName, FileUtilRt.toSystemIndependentName((String)path));
    }

    public void put(@NotNull String fromText, @NotNull String toText) {
        if (fromText == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(2);
        }
        if (toText == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(3);
        }
        this.myPlainMap.put(fromText, toText);
    }

    @ApiStatus.Internal
    public void putAll(@NotNull ExpandMacroToPathMap another) {
        if (another == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(4);
        }
        this.myPlainMap.putAll(another.myPlainMap);
        this.myMacroExpands.putAll(another.myMacroExpands);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public String substitute(@NotNull String text, boolean caseSensitive) {
        if (text == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(5);
        }
        if (text.indexOf(36) < 0 && text.indexOf(37) < 0) {
            String string = text;
            if (string == null) {
                ExpandMacroToPathMap.$$$reportNull$$$0(6);
            }
            return string;
        }
        for (Map.Entry<String, String> entry : this.myPlainMap.entrySet()) {
            text = StringUtil.replace((String)text, (String)entry.getKey(), (String)entry.getValue(), (boolean)false);
        }
        for (String macroName : this.myMacroExpands.keySet()) {
            text = ExpandMacroToPathMap.replaceMacro(text, macroName, this.myMacroExpands.get(macroName));
        }
        String string = text;
        if (string == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String replaceMacro(@NotNull String text, @NotNull String macroName, @NotNull String replacement) {
        int start;
        if (text == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(8);
        }
        if (macroName == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(9);
        }
        if (replacement == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(10);
        }
        while ((start = ExpandMacroToPathMap.findMacroIndex(text, macroName)) >= 0) {
            int end = start + macroName.length() + 2;
            int slashCount = ExpandMacroToPathMap.getSlashCount(text, end);
            String actualReplacement = slashCount > 0 && !replacement.endsWith("/") ? replacement + "/" : replacement;
            text = StringUtil.replaceSubstring((String)text, (TextRange)new TextRange(start, end + slashCount), (String)actualReplacement);
        }
        String string = text;
        if (string == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static int getSlashCount(@NotNull String text, int pos) {
        if (text == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(12);
        }
        return StringUtil.isChar((CharSequence)text, (int)pos, (char)'/') ? (StringUtil.isChar((CharSequence)text, (int)(pos + 1), (char)'/') ? 2 : 1) : 0;
    }

    private static int findMacroIndex(@NotNull String text, @NotNull String macroName) {
        if (text == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(13);
        }
        if (macroName == null) {
            ExpandMacroToPathMap.$$$reportNull$$$0(14);
        }
        int i = -1;
        do {
            if ((i = text.indexOf(36, i + 1)) >= 0) continue;
            return -1;
        } while (!StringUtil.startsWith((CharSequence)text, (int)(i + 1), (CharSequence)macroName) || !StringUtil.isChar((CharSequence)text, (int)(i + macroName.length() + 1), (char)'$'));
        return i;
    }

    @Override
    @ApiStatus.Internal
    public int hashCode() {
        return this.myPlainMap.hashCode() + this.myMacroExpands.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/ExpandMacroToPathMap";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/ExpandMacroToPathMap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceMacro";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addMacroExpand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceMacro";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSlashCount";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findMacroIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

