/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUarrayMapInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESOURCETYPE;
    public static final int RESOURCE;
    public static final int RESOURCE_MIPMAP;
    public static final int RESOURCE_ARRAY;
    public static final int SUBRESOURCETYPE;
    public static final int SUBRESOURCE;
    public static final int SUBRESOURCE_SPARSELEVEL;
    public static final int SUBRESOURCE_SPARSELEVEL_LEVEL;
    public static final int SUBRESOURCE_SPARSELEVEL_LAYER;
    public static final int SUBRESOURCE_SPARSELEVEL_OFFSETX;
    public static final int SUBRESOURCE_SPARSELEVEL_OFFSETY;
    public static final int SUBRESOURCE_SPARSELEVEL_OFFSETZ;
    public static final int SUBRESOURCE_SPARSELEVEL_EXTENTWIDTH;
    public static final int SUBRESOURCE_SPARSELEVEL_EXTENTHEIGHT;
    public static final int SUBRESOURCE_SPARSELEVEL_EXTENTDEPTH;
    public static final int SUBRESOURCE_MIPTAIL;
    public static final int SUBRESOURCE_MIPTAIL_LAYER;
    public static final int SUBRESOURCE_MIPTAIL_OFFSET;
    public static final int SUBRESOURCE_MIPTAIL_SIZE;
    public static final int MEMOPERATIONTYPE;
    public static final int MEMHANDLETYPE;
    public static final int MEMHANDLE;
    public static final int MEMHANDLE_MEMHANDLE;
    public static final int OFFSET;
    public static final int DEVICEBITMASK;
    public static final int FLAGS;
    public static final int RESERVED;

    public CUarrayMapInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUarrayMapInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUresourcetype")
    public int resourceType() {
        return CUarrayMapInfo.nresourceType(this.address());
    }

    @NativeType(value="CUmipmappedArray")
    public long resource_mipmap() {
        return CUarrayMapInfo.nresource_mipmap(this.address());
    }

    @NativeType(value="CUarray")
    public long resource_array() {
        return CUarrayMapInfo.nresource_array(this.address());
    }

    @NativeType(value="CUarraySparseSubresourceType")
    public int subresourceType() {
        return CUarrayMapInfo.nsubresourceType(this.address());
    }

    @NativeType(value="unsigned int")
    public int subresource_sparseLevel_level() {
        return CUarrayMapInfo.nsubresource_sparseLevel_level(this.address());
    }

    @NativeType(value="unsigned int")
    public int subresource_sparseLevel_layer() {
        return CUarrayMapInfo.nsubresource_sparseLevel_layer(this.address());
    }

    @NativeType(value="unsigned int")
    public int subresource_sparseLevel_offsetX() {
        return CUarrayMapInfo.nsubresource_sparseLevel_offsetX(this.address());
    }

    @NativeType(value="unsigned int")
    public int subresource_sparseLevel_offsetY() {
        return CUarrayMapInfo.nsubresource_sparseLevel_offsetY(this.address());
    }

    @NativeType(value="unsigned int")
    public int subresource_sparseLevel_offsetZ() {
        return CUarrayMapInfo.nsubresource_sparseLevel_offsetZ(this.address());
    }

    @NativeType(value="unsigned int")
    public int subresource_sparseLevel_extentWidth() {
        return CUarrayMapInfo.nsubresource_sparseLevel_extentWidth(this.address());
    }

    @NativeType(value="unsigned int")
    public int subresource_sparseLevel_extentHeight() {
        return CUarrayMapInfo.nsubresource_sparseLevel_extentHeight(this.address());
    }

    @NativeType(value="unsigned int")
    public int subresource_sparseLevel_extentDepth() {
        return CUarrayMapInfo.nsubresource_sparseLevel_extentDepth(this.address());
    }

    @NativeType(value="unsigned int")
    public int subresource_miptail_layer() {
        return CUarrayMapInfo.nsubresource_miptail_layer(this.address());
    }

    @NativeType(value="unsigned long long")
    public long subresource_miptail_offset() {
        return CUarrayMapInfo.nsubresource_miptail_offset(this.address());
    }

    @NativeType(value="unsigned long long")
    public long subresource_miptail_size() {
        return CUarrayMapInfo.nsubresource_miptail_size(this.address());
    }

    @NativeType(value="CUmemOperationType")
    public int memOperationType() {
        return CUarrayMapInfo.nmemOperationType(this.address());
    }

    @NativeType(value="CUmemHandleType")
    public int memHandleType() {
        return CUarrayMapInfo.nmemHandleType(this.address());
    }

    @NativeType(value="CUmemGenericAllocationHandle")
    public long memHandle_memHandle() {
        return CUarrayMapInfo.nmemHandle_memHandle(this.address());
    }

    @NativeType(value="unsigned long long")
    public long offset() {
        return CUarrayMapInfo.noffset(this.address());
    }

    @NativeType(value="unsigned int")
    public int deviceBitMask() {
        return CUarrayMapInfo.ndeviceBitMask(this.address());
    }

    @NativeType(value="unsigned int")
    public int flags() {
        return CUarrayMapInfo.nflags(this.address());
    }

    @NativeType(value="unsigned int[2]")
    public IntBuffer reserved() {
        return CUarrayMapInfo.nreserved(this.address());
    }

    @NativeType(value="unsigned int")
    public int reserved(int index) {
        return CUarrayMapInfo.nreserved(this.address(), index);
    }

    public CUarrayMapInfo resourceType(@NativeType(value="CUresourcetype") int value) {
        CUarrayMapInfo.nresourceType(this.address(), value);
        return this;
    }

    public CUarrayMapInfo resource_mipmap(@NativeType(value="CUmipmappedArray") long value) {
        CUarrayMapInfo.nresource_mipmap(this.address(), value);
        return this;
    }

    public CUarrayMapInfo resource_array(@NativeType(value="CUarray") long value) {
        CUarrayMapInfo.nresource_array(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresourceType(@NativeType(value="CUarraySparseSubresourceType") int value) {
        CUarrayMapInfo.nsubresourceType(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_sparseLevel_level(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nsubresource_sparseLevel_level(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_sparseLevel_layer(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nsubresource_sparseLevel_layer(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_sparseLevel_offsetX(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nsubresource_sparseLevel_offsetX(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_sparseLevel_offsetY(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nsubresource_sparseLevel_offsetY(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_sparseLevel_offsetZ(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nsubresource_sparseLevel_offsetZ(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_sparseLevel_extentWidth(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nsubresource_sparseLevel_extentWidth(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_sparseLevel_extentHeight(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nsubresource_sparseLevel_extentHeight(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_sparseLevel_extentDepth(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nsubresource_sparseLevel_extentDepth(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_miptail_layer(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nsubresource_miptail_layer(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_miptail_offset(@NativeType(value="unsigned long long") long value) {
        CUarrayMapInfo.nsubresource_miptail_offset(this.address(), value);
        return this;
    }

    public CUarrayMapInfo subresource_miptail_size(@NativeType(value="unsigned long long") long value) {
        CUarrayMapInfo.nsubresource_miptail_size(this.address(), value);
        return this;
    }

    public CUarrayMapInfo memOperationType(@NativeType(value="CUmemOperationType") int value) {
        CUarrayMapInfo.nmemOperationType(this.address(), value);
        return this;
    }

    public CUarrayMapInfo memHandleType(@NativeType(value="CUmemHandleType") int value) {
        CUarrayMapInfo.nmemHandleType(this.address(), value);
        return this;
    }

    public CUarrayMapInfo memHandle_memHandle(@NativeType(value="CUmemGenericAllocationHandle") long value) {
        CUarrayMapInfo.nmemHandle_memHandle(this.address(), value);
        return this;
    }

    public CUarrayMapInfo offset(@NativeType(value="unsigned long long") long value) {
        CUarrayMapInfo.noffset(this.address(), value);
        return this;
    }

    public CUarrayMapInfo deviceBitMask(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.ndeviceBitMask(this.address(), value);
        return this;
    }

    public CUarrayMapInfo flags(@NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nflags(this.address(), value);
        return this;
    }

    public CUarrayMapInfo reserved(@NativeType(value="unsigned int[2]") IntBuffer value) {
        CUarrayMapInfo.nreserved(this.address(), value);
        return this;
    }

    public CUarrayMapInfo reserved(int index, @NativeType(value="unsigned int") int value) {
        CUarrayMapInfo.nreserved(this.address(), index, value);
        return this;
    }

    public CUarrayMapInfo set(CUarrayMapInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUarrayMapInfo malloc() {
        return (CUarrayMapInfo)CUarrayMapInfo.wrap(CUarrayMapInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUarrayMapInfo calloc() {
        return (CUarrayMapInfo)CUarrayMapInfo.wrap(CUarrayMapInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUarrayMapInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUarrayMapInfo)CUarrayMapInfo.wrap(CUarrayMapInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUarrayMapInfo create(long address) {
        return (CUarrayMapInfo)CUarrayMapInfo.wrap(CUarrayMapInfo.class, (long)address);
    }

    @Nullable
    public static CUarrayMapInfo createSafe(long address) {
        return address == 0L ? null : (CUarrayMapInfo)CUarrayMapInfo.wrap(CUarrayMapInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUarrayMapInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUarrayMapInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUarrayMapInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUarrayMapInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUarrayMapInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUarrayMapInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUarrayMapInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CUarrayMapInfo malloc(MemoryStack stack) {
        return (CUarrayMapInfo)CUarrayMapInfo.wrap(CUarrayMapInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUarrayMapInfo calloc(MemoryStack stack) {
        return (CUarrayMapInfo)CUarrayMapInfo.wrap(CUarrayMapInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUarrayMapInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUarrayMapInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nresourceType(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESOURCETYPE);
    }

    public static long nresource_mipmap(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)RESOURCE_MIPMAP));
    }

    public static long nresource_array(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)RESOURCE_ARRAY));
    }

    public static int nsubresourceType(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBRESOURCETYPE);
    }

    public static int nsubresource_sparseLevel_level(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_LEVEL);
    }

    public static int nsubresource_sparseLevel_layer(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_LAYER);
    }

    public static int nsubresource_sparseLevel_offsetX(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_OFFSETX);
    }

    public static int nsubresource_sparseLevel_offsetY(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_OFFSETY);
    }

    public static int nsubresource_sparseLevel_offsetZ(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_OFFSETZ);
    }

    public static int nsubresource_sparseLevel_extentWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_EXTENTWIDTH);
    }

    public static int nsubresource_sparseLevel_extentHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_EXTENTHEIGHT);
    }

    public static int nsubresource_sparseLevel_extentDepth(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_EXTENTDEPTH);
    }

    public static int nsubresource_miptail_layer(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBRESOURCE_MIPTAIL_LAYER);
    }

    public static long nsubresource_miptail_offset(long struct) {
        return UNSAFE.getLong(null, struct + (long)SUBRESOURCE_MIPTAIL_OFFSET);
    }

    public static long nsubresource_miptail_size(long struct) {
        return UNSAFE.getLong(null, struct + (long)SUBRESOURCE_MIPTAIL_SIZE);
    }

    public static int nmemOperationType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMOPERATIONTYPE);
    }

    public static int nmemHandleType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMHANDLETYPE);
    }

    public static long nmemHandle_memHandle(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMHANDLE_MEMHANDLE);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static int ndeviceBitMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEBITMASK);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)RESERVED), (int)2);
    }

    public static int nreserved(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)2) * 4L);
    }

    public static void nresourceType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RESOURCETYPE, value);
    }

    public static void nresource_mipmap(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RESOURCE_MIPMAP), (long)value);
    }

    public static void nresource_array(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RESOURCE_ARRAY), (long)value);
    }

    public static void nsubresourceType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBRESOURCETYPE, value);
    }

    public static void nsubresource_sparseLevel_level(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_LEVEL, value);
    }

    public static void nsubresource_sparseLevel_layer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_LAYER, value);
    }

    public static void nsubresource_sparseLevel_offsetX(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_OFFSETX, value);
    }

    public static void nsubresource_sparseLevel_offsetY(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_OFFSETY, value);
    }

    public static void nsubresource_sparseLevel_offsetZ(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_OFFSETZ, value);
    }

    public static void nsubresource_sparseLevel_extentWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_EXTENTWIDTH, value);
    }

    public static void nsubresource_sparseLevel_extentHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_EXTENTHEIGHT, value);
    }

    public static void nsubresource_sparseLevel_extentDepth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBRESOURCE_SPARSELEVEL_EXTENTDEPTH, value);
    }

    public static void nsubresource_miptail_layer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUBRESOURCE_MIPTAIL_LAYER, value);
    }

    public static void nsubresource_miptail_offset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SUBRESOURCE_MIPTAIL_OFFSET, value);
    }

    public static void nsubresource_miptail_size(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SUBRESOURCE_MIPTAIL_SIZE, value);
    }

    public static void nmemOperationType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMOPERATIONTYPE, value);
    }

    public static void nmemHandleType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMHANDLETYPE, value);
    }

    public static void nmemHandle_memHandle(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMHANDLE_MEMHANDLE, value);
    }

    public static void noffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OFFSET, value);
    }

    public static void ndeviceBitMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEBITMASK, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)RESERVED), (long)(value.remaining() * 4));
    }

    public static void nreserved(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED + Checks.check((int)index, (int)2) * 4L, value);
    }

    static {
        Struct.Layout layout = CUarrayMapInfo.__struct((Struct.Member[])new Struct.Member[]{CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__union((Struct.Member[])new Struct.Member[]{CUarrayMapInfo.__member((int)POINTER_SIZE), CUarrayMapInfo.__member((int)POINTER_SIZE)}), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__union((Struct.Member[])new Struct.Member[]{CUarrayMapInfo.__struct((Struct.Member[])new Struct.Member[]{CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__member((int)4)}), CUarrayMapInfo.__struct((Struct.Member[])new Struct.Member[]{CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__member((int)8), CUarrayMapInfo.__member((int)8)})}), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__union((Struct.Member[])new Struct.Member[]{CUarrayMapInfo.__member((int)8)}), CUarrayMapInfo.__member((int)8), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__member((int)4), CUarrayMapInfo.__array((int)4, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESOURCETYPE = layout.offsetof(0);
        RESOURCE = layout.offsetof(1);
        RESOURCE_MIPMAP = layout.offsetof(2);
        RESOURCE_ARRAY = layout.offsetof(3);
        SUBRESOURCETYPE = layout.offsetof(4);
        SUBRESOURCE = layout.offsetof(5);
        SUBRESOURCE_SPARSELEVEL = layout.offsetof(6);
        SUBRESOURCE_SPARSELEVEL_LEVEL = layout.offsetof(7);
        SUBRESOURCE_SPARSELEVEL_LAYER = layout.offsetof(8);
        SUBRESOURCE_SPARSELEVEL_OFFSETX = layout.offsetof(9);
        SUBRESOURCE_SPARSELEVEL_OFFSETY = layout.offsetof(10);
        SUBRESOURCE_SPARSELEVEL_OFFSETZ = layout.offsetof(11);
        SUBRESOURCE_SPARSELEVEL_EXTENTWIDTH = layout.offsetof(12);
        SUBRESOURCE_SPARSELEVEL_EXTENTHEIGHT = layout.offsetof(13);
        SUBRESOURCE_SPARSELEVEL_EXTENTDEPTH = layout.offsetof(14);
        SUBRESOURCE_MIPTAIL = layout.offsetof(15);
        SUBRESOURCE_MIPTAIL_LAYER = layout.offsetof(16);
        SUBRESOURCE_MIPTAIL_OFFSET = layout.offsetof(17);
        SUBRESOURCE_MIPTAIL_SIZE = layout.offsetof(18);
        MEMOPERATIONTYPE = layout.offsetof(19);
        MEMHANDLETYPE = layout.offsetof(20);
        MEMHANDLE = layout.offsetof(21);
        MEMHANDLE_MEMHANDLE = layout.offsetof(22);
        OFFSET = layout.offsetof(23);
        DEVICEBITMASK = layout.offsetof(24);
        FLAGS = layout.offsetof(25);
        RESERVED = layout.offsetof(26);
    }

    public static class Buffer
    extends StructBuffer<CUarrayMapInfo, Buffer>
    implements NativeResource {
        private static final CUarrayMapInfo ELEMENT_FACTORY = CUarrayMapInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUarrayMapInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUresourcetype")
        public int resourceType() {
            return CUarrayMapInfo.nresourceType(this.address());
        }

        @NativeType(value="CUmipmappedArray")
        public long resource_mipmap() {
            return CUarrayMapInfo.nresource_mipmap(this.address());
        }

        @NativeType(value="CUarray")
        public long resource_array() {
            return CUarrayMapInfo.nresource_array(this.address());
        }

        @NativeType(value="CUarraySparseSubresourceType")
        public int subresourceType() {
            return CUarrayMapInfo.nsubresourceType(this.address());
        }

        @NativeType(value="unsigned int")
        public int subresource_sparseLevel_level() {
            return CUarrayMapInfo.nsubresource_sparseLevel_level(this.address());
        }

        @NativeType(value="unsigned int")
        public int subresource_sparseLevel_layer() {
            return CUarrayMapInfo.nsubresource_sparseLevel_layer(this.address());
        }

        @NativeType(value="unsigned int")
        public int subresource_sparseLevel_offsetX() {
            return CUarrayMapInfo.nsubresource_sparseLevel_offsetX(this.address());
        }

        @NativeType(value="unsigned int")
        public int subresource_sparseLevel_offsetY() {
            return CUarrayMapInfo.nsubresource_sparseLevel_offsetY(this.address());
        }

        @NativeType(value="unsigned int")
        public int subresource_sparseLevel_offsetZ() {
            return CUarrayMapInfo.nsubresource_sparseLevel_offsetZ(this.address());
        }

        @NativeType(value="unsigned int")
        public int subresource_sparseLevel_extentWidth() {
            return CUarrayMapInfo.nsubresource_sparseLevel_extentWidth(this.address());
        }

        @NativeType(value="unsigned int")
        public int subresource_sparseLevel_extentHeight() {
            return CUarrayMapInfo.nsubresource_sparseLevel_extentHeight(this.address());
        }

        @NativeType(value="unsigned int")
        public int subresource_sparseLevel_extentDepth() {
            return CUarrayMapInfo.nsubresource_sparseLevel_extentDepth(this.address());
        }

        @NativeType(value="unsigned int")
        public int subresource_miptail_layer() {
            return CUarrayMapInfo.nsubresource_miptail_layer(this.address());
        }

        @NativeType(value="unsigned long long")
        public long subresource_miptail_offset() {
            return CUarrayMapInfo.nsubresource_miptail_offset(this.address());
        }

        @NativeType(value="unsigned long long")
        public long subresource_miptail_size() {
            return CUarrayMapInfo.nsubresource_miptail_size(this.address());
        }

        @NativeType(value="CUmemOperationType")
        public int memOperationType() {
            return CUarrayMapInfo.nmemOperationType(this.address());
        }

        @NativeType(value="CUmemHandleType")
        public int memHandleType() {
            return CUarrayMapInfo.nmemHandleType(this.address());
        }

        @NativeType(value="CUmemGenericAllocationHandle")
        public long memHandle_memHandle() {
            return CUarrayMapInfo.nmemHandle_memHandle(this.address());
        }

        @NativeType(value="unsigned long long")
        public long offset() {
            return CUarrayMapInfo.noffset(this.address());
        }

        @NativeType(value="unsigned int")
        public int deviceBitMask() {
            return CUarrayMapInfo.ndeviceBitMask(this.address());
        }

        @NativeType(value="unsigned int")
        public int flags() {
            return CUarrayMapInfo.nflags(this.address());
        }

        @NativeType(value="unsigned int[2]")
        public IntBuffer reserved() {
            return CUarrayMapInfo.nreserved(this.address());
        }

        @NativeType(value="unsigned int")
        public int reserved(int index) {
            return CUarrayMapInfo.nreserved(this.address(), index);
        }

        public Buffer resourceType(@NativeType(value="CUresourcetype") int value) {
            CUarrayMapInfo.nresourceType(this.address(), value);
            return this;
        }

        public Buffer resource_mipmap(@NativeType(value="CUmipmappedArray") long value) {
            CUarrayMapInfo.nresource_mipmap(this.address(), value);
            return this;
        }

        public Buffer resource_array(@NativeType(value="CUarray") long value) {
            CUarrayMapInfo.nresource_array(this.address(), value);
            return this;
        }

        public Buffer subresourceType(@NativeType(value="CUarraySparseSubresourceType") int value) {
            CUarrayMapInfo.nsubresourceType(this.address(), value);
            return this;
        }

        public Buffer subresource_sparseLevel_level(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nsubresource_sparseLevel_level(this.address(), value);
            return this;
        }

        public Buffer subresource_sparseLevel_layer(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nsubresource_sparseLevel_layer(this.address(), value);
            return this;
        }

        public Buffer subresource_sparseLevel_offsetX(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nsubresource_sparseLevel_offsetX(this.address(), value);
            return this;
        }

        public Buffer subresource_sparseLevel_offsetY(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nsubresource_sparseLevel_offsetY(this.address(), value);
            return this;
        }

        public Buffer subresource_sparseLevel_offsetZ(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nsubresource_sparseLevel_offsetZ(this.address(), value);
            return this;
        }

        public Buffer subresource_sparseLevel_extentWidth(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nsubresource_sparseLevel_extentWidth(this.address(), value);
            return this;
        }

        public Buffer subresource_sparseLevel_extentHeight(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nsubresource_sparseLevel_extentHeight(this.address(), value);
            return this;
        }

        public Buffer subresource_sparseLevel_extentDepth(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nsubresource_sparseLevel_extentDepth(this.address(), value);
            return this;
        }

        public Buffer subresource_miptail_layer(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nsubresource_miptail_layer(this.address(), value);
            return this;
        }

        public Buffer subresource_miptail_offset(@NativeType(value="unsigned long long") long value) {
            CUarrayMapInfo.nsubresource_miptail_offset(this.address(), value);
            return this;
        }

        public Buffer subresource_miptail_size(@NativeType(value="unsigned long long") long value) {
            CUarrayMapInfo.nsubresource_miptail_size(this.address(), value);
            return this;
        }

        public Buffer memOperationType(@NativeType(value="CUmemOperationType") int value) {
            CUarrayMapInfo.nmemOperationType(this.address(), value);
            return this;
        }

        public Buffer memHandleType(@NativeType(value="CUmemHandleType") int value) {
            CUarrayMapInfo.nmemHandleType(this.address(), value);
            return this;
        }

        public Buffer memHandle_memHandle(@NativeType(value="CUmemGenericAllocationHandle") long value) {
            CUarrayMapInfo.nmemHandle_memHandle(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="unsigned long long") long value) {
            CUarrayMapInfo.noffset(this.address(), value);
            return this;
        }

        public Buffer deviceBitMask(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.ndeviceBitMask(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned int[2]") IntBuffer value) {
            CUarrayMapInfo.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned int") int value) {
            CUarrayMapInfo.nreserved(this.address(), index, value);
            return this;
        }
    }
}

