/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViewState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VIEWSTATEFLAGS;

    public XrViewState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrViewState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViewState.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrViewState.nnext(this.address());
    }

    @NativeType(value="XrViewStateFlags")
    public long viewStateFlags() {
        return XrViewState.nviewStateFlags(this.address());
    }

    public XrViewState type(@NativeType(value="XrStructureType") int value) {
        XrViewState.ntype(this.address(), value);
        return this;
    }

    public XrViewState type$Default() {
        return this.type(11);
    }

    public XrViewState next(@NativeType(value="void *") long value) {
        XrViewState.nnext(this.address(), value);
        return this;
    }

    public XrViewState viewStateFlags(@NativeType(value="XrViewStateFlags") long value) {
        XrViewState.nviewStateFlags(this.address(), value);
        return this;
    }

    public XrViewState set(int type, long next, long viewStateFlags) {
        this.type(type);
        this.next(next);
        this.viewStateFlags(viewStateFlags);
        return this;
    }

    public XrViewState set(XrViewState src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrViewState malloc() {
        return (XrViewState)XrViewState.wrap(XrViewState.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrViewState calloc() {
        return (XrViewState)XrViewState.wrap(XrViewState.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrViewState create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrViewState)XrViewState.wrap(XrViewState.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrViewState create(long address) {
        return (XrViewState)XrViewState.wrap(XrViewState.class, (long)address);
    }

    @Nullable
    public static XrViewState createSafe(long address) {
        return address == 0L ? null : (XrViewState)XrViewState.wrap(XrViewState.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrViewState.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrViewState.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrViewState.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViewState.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrViewState.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrViewState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrViewState.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrViewState malloc(MemoryStack stack) {
        return (XrViewState)XrViewState.wrap(XrViewState.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrViewState calloc(MemoryStack stack) {
        return (XrViewState)XrViewState.wrap(XrViewState.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrViewState.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrViewState.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nviewStateFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)VIEWSTATEFLAGS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nviewStateFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VIEWSTATEFLAGS, value);
    }

    static {
        Struct.Layout layout = XrViewState.__struct((Struct.Member[])new Struct.Member[]{XrViewState.__member((int)4), XrViewState.__member((int)POINTER_SIZE), XrViewState.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VIEWSTATEFLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrViewState, Buffer>
    implements NativeResource {
        private static final XrViewState ELEMENT_FACTORY = XrViewState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrViewState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViewState.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrViewState.nnext(this.address());
        }

        @NativeType(value="XrViewStateFlags")
        public long viewStateFlags() {
            return XrViewState.nviewStateFlags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViewState.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(11);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrViewState.nnext(this.address(), value);
            return this;
        }

        public Buffer viewStateFlags(@NativeType(value="XrViewStateFlags") long value) {
            XrViewState.nviewStateFlags(this.address(), value);
            return this;
        }
    }
}

