/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.model.Config;

public class ValidateConfigRequest
extends ActionRequest {
    private final AnalysisType context;
    private final Config config;
    private final String validationType;
    private final Integer maxSingleStreamConfigs;
    private final Integer maxHCConfigs;
    private final Integer maxFeatures;
    private final TimeValue requestTimeout;
    private final Integer maxCategoricalFields;

    public ValidateConfigRequest(StreamInput in) throws IOException {
        super(in);
        this.context = (AnalysisType)in.readEnum(AnalysisType.class);
        if (this.context.isAD()) {
            this.config = new AnomalyDetector(in);
        } else if (this.context.isForecast()) {
            this.config = new Forecaster(in);
        } else {
            throw new UnsupportedOperationException("This method is not supported");
        }
        this.validationType = in.readString();
        this.maxSingleStreamConfigs = in.readInt();
        this.maxHCConfigs = in.readInt();
        this.maxFeatures = in.readInt();
        this.requestTimeout = in.readTimeValue();
        this.maxCategoricalFields = in.readInt();
    }

    public ValidateConfigRequest(AnalysisType context, Config config, String validationType, Integer maxSingleStreamConfigs, Integer maxHCConfigs, Integer maxFeatures, TimeValue requestTimeout, Integer maxCategoricalFields) {
        this.context = context;
        this.config = config;
        this.validationType = validationType;
        this.maxSingleStreamConfigs = maxSingleStreamConfigs;
        this.maxHCConfigs = maxHCConfigs;
        this.maxFeatures = maxFeatures;
        this.requestTimeout = requestTimeout;
        this.maxCategoricalFields = maxCategoricalFields;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.context);
        this.config.writeTo(out);
        out.writeString(this.validationType);
        out.writeInt(this.maxSingleStreamConfigs.intValue());
        out.writeInt(this.maxHCConfigs.intValue());
        out.writeInt(this.maxFeatures.intValue());
        out.writeTimeValue(this.requestTimeout);
        out.writeInt(this.maxCategoricalFields.intValue());
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getValidationType() {
        return this.validationType;
    }

    public Integer getMaxSingleEntityAnomalyDetectors() {
        return this.maxSingleStreamConfigs;
    }

    public Integer getMaxMultiEntityAnomalyDetectors() {
        return this.maxHCConfigs;
    }

    public Integer getMaxAnomalyFeatures() {
        return this.maxFeatures;
    }

    public TimeValue getRequestTimeout() {
        return this.requestTimeout;
    }

    public Integer getMaxCategoricalFields() {
        return this.maxCategoricalFields;
    }

    /*
     * Exception decompiling
     */
    public static ValidateConfigRequest fromActionRequest(ActionRequest actionRequest, NamedWriteableRegistry namedWriteableRegistry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

