/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.XContent;

public class AutoCorrelationsRepo {
    private static String autoCorrelations() throws IOException {
        return new String(Objects.requireNonNull(AutoCorrelationsRepo.class.getClassLoader().getResourceAsStream("correlations/mitre_correlation.json")).readAllBytes(), Charset.defaultCharset());
    }

    public static Map<String, Set<String>> autoCorrelationsAsMap() throws IOException {
        XContentType contentType = XContentType.JSON;
        Map autoCorrelationData = XContentHelper.convertToMap((XContent)contentType.xContent(), (String)AutoCorrelationsRepo.autoCorrelations(), (boolean)false);
        HashMap<String, Set<String>> autoCorrelations = new HashMap<String, Set<String>>();
        for (Map.Entry autoCorrelationDataEntry : autoCorrelationData.entrySet()) {
            String intrusionSet = (String)autoCorrelationDataEntry.getKey();
            HashSet<String> tags = new HashSet<String>();
            if (autoCorrelationDataEntry.getValue() instanceof ArrayList) {
                List autoCorrelationTags = (List)autoCorrelationDataEntry.getValue();
                for (Map autoCorrelationTag : autoCorrelationTags) {
                    tags.add(autoCorrelationTag.get("mitreAttackId").toString());
                }
            }
            autoCorrelations.put(intrusionSet, tags);
        }
        return autoCorrelations;
    }

    public static Set<String> validIntrusionSets(Map<String, Set<String>> autoCorrelations, Set<String> tags) {
        HashSet<String> intrusionSets = new HashSet<String>();
        for (Map.Entry<String, Set<String>> autoCorrelation : autoCorrelations.entrySet()) {
            for (String tag : tags) {
                if (!autoCorrelation.getValue().contains(tag)) continue;
                intrusionSets.add(autoCorrelation.getKey());
            }
        }
        return intrusionSets;
    }
}

