/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature;

import com.o19s.es.ltr.LtrQueryContext;
import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.common.Nullable;
import org.opensearch.ltr.settings.LTRSettings;

public class PrebuiltFeature
extends Query
implements Feature {
    private final String name;
    private final Query query;

    public PrebuiltFeature(@Nullable String name, Query query) {
        this.name = name;
        this.query = Objects.requireNonNull(query);
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    public Query doToQuery(LtrQueryContext context, FeatureSet set, Map<String, Object> params) {
        return this.query;
    }

    public Query getPrebuiltQuery() {
        return this.query;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.query);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PrebuiltFeature)) {
            return false;
        }
        PrebuiltFeature other = (PrebuiltFeature)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.query, other.query);
    }

    public String toString(String field) {
        return this.query.toString(field);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (!LTRSettings.isLTRPluginEnabled()) {
            throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
        }
        return this.query.createWeight(searcher, scoreMode, boost);
    }

    public Query rewrite(IndexSearcher reader) throws IOException {
        return this.query.rewrite(reader);
    }

    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this));
    }
}

