/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.model;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.JudgmentType;

public class Judgment
implements ToXContentObject {
    public static final String ID = "id";
    public static final String TIME_STAMP = "timestamp";
    public static final String NAME = "name";
    public static final String STATUS = "status";
    public static final String TYPE = "type";
    public static final String METADATA = "metadata";
    public static final String JUDGMENT_RATINGS = "judgmentRatings";
    private final String id;
    private final String timestamp;
    private final String name;
    private final AsyncStatus status;
    private final JudgmentType type;
    private final Map<String, Object> metadata;
    private final List<Map<String, Object>> judgmentRatings;

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        xContentBuilder.field(ID, this.id.trim());
        xContentBuilder.field(TIME_STAMP, this.timestamp.trim());
        xContentBuilder.field(NAME, this.name.trim());
        xContentBuilder.field(STATUS, this.status.name().trim());
        xContentBuilder.field(TYPE, this.type.name().trim());
        xContentBuilder.field(METADATA, this.metadata);
        xContentBuilder.startArray(JUDGMENT_RATINGS);
        for (Map<String, Object> judgment : this.judgmentRatings) {
            xContentBuilder.startObject();
            xContentBuilder.field("query", judgment.get("query"));
            xContentBuilder.startArray("ratings");
            for (Map rating : (List)judgment.get("ratings")) {
                xContentBuilder.startObject();
                for (Map.Entry entry : rating.entrySet()) {
                    xContentBuilder.field((String)entry.getKey(), entry.getValue());
                }
                xContentBuilder.endObject();
            }
            xContentBuilder.endArray();
            xContentBuilder.endObject();
        }
        xContentBuilder.endArray();
        return xContentBuilder.endObject();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public AsyncStatus getStatus() {
        return this.status;
    }

    @Generated
    public JudgmentType getType() {
        return this.type;
    }

    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public List<Map<String, Object>> getJudgmentRatings() {
        return this.judgmentRatings;
    }

    @Generated
    public Judgment(String id, String timestamp, String name, AsyncStatus status, JudgmentType type, Map<String, Object> metadata, List<Map<String, Object>> judgmentRatings) {
        this.id = id;
        this.timestamp = timestamp;
        this.name = name;
        this.status = status;
        this.type = type;
        this.metadata = metadata;
        this.judgmentRatings = judgmentRatings;
    }
}

