/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sf.mpxj.Duration;
import net.sf.mpxj.explorer.ObjectPropertiesModel;

public class ObjectPropertiesController {
    private final ObjectPropertiesModel m_model;

    public ObjectPropertiesController(ObjectPropertiesModel objectPropertiesModel) {
        this.m_model = objectPropertiesModel;
    }

    public void loadObject(Object object, Set<String> set) {
        this.m_model.setTableModel(this.createTableModel(object, set));
    }

    private TableModel createTableModel(Object object, Set<String> set) {
        Object object2;
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : object.getClass().getMethods()) {
            if (method.getParameterTypes().length != 0 && (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Integer.TYPE) || set.contains(object2 = method.getName()) || !((String)object2).startsWith("get") && !((String)object2).startsWith("is")) continue;
            arrayList.add(method);
        }
        TreeMap treeMap = new TreeMap();
        for (Method method : arrayList) {
            if (method.getParameterTypes().length == 0) {
                this.getSingleValue(method, object, treeMap);
                continue;
            }
            this.getMultipleValues(method, object, treeMap);
        }
        Object[] objectArray = new String[]{"Property", "Value"};
        Object[][] objectArray2 = new String[treeMap.size()][2];
        int n = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            objectArray2[n][0] = (String)entry.getKey();
            objectArray2[n][1] = (String)entry.getValue();
            ++n;
        }
        object2 = new DefaultTableModel(objectArray2, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        return object2;
    }

    private Object filterValue(Object object) {
        if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
            object = null;
        }
        if (object instanceof String && ((String)object).isEmpty()) {
            object = null;
        }
        if (object instanceof Double && (Double)object == 0.0) {
            object = null;
        }
        if (object instanceof Integer && (Integer)object == 0) {
            object = null;
        }
        if (object instanceof Duration && ((Duration)object).getDuration() == 0.0) {
            object = null;
        }
        return object;
    }

    private void getSingleValue(Method method, Object object, Map<String, String> map) {
        Object object2;
        try {
            object2 = this.filterValue(method.invoke(object, new Object[0]));
        }
        catch (Exception exception) {
            object2 = exception.toString();
        }
        if (object2 != null) {
            map.put(this.getPropertyName(method), String.valueOf(object2));
        }
    }

    private void getMultipleValues(Method method, Object object, Map<String, String> map) {
        try {
            int n = 1;
            while (true) {
                Object object2;
                if ((object2 = this.filterValue(method.invoke(object, n))) != null) {
                    map.put(this.getPropertyName(method, n), String.valueOf(object2));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private String getPropertyName(Method method) {
        String string = method.getName();
        if (string.startsWith("get")) {
            string = string.substring(3);
        }
        return string;
    }

    private String getPropertyName(Method method, int n) {
        return method.getName().substring(3) + n;
    }
}

