/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Date;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.GraphicalIndicator;
import net.sf.mpxj.GraphicalIndicatorCriteria;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;

public final class GraphicalIndicatorReader {
    private byte[] m_data;
    private int m_headerOffset;
    private int m_dataOffset;
    private CustomFieldContainer m_container;
    private ProjectProperties m_properties;

    public void process(CustomFieldContainer customFieldContainer, ProjectProperties projectProperties, Props props) {
        this.m_container = customFieldContainer;
        this.m_properties = projectProperties;
        this.m_data = props.getByteArray(Props.TASK_FIELD_ATTRIBUTES);
        if (this.m_data != null) {
            int n = MPPUtility.getInt(this.m_data, 4);
            this.m_headerOffset = 8;
            for (int i = 0; i < n; ++i) {
                this.processColumns();
            }
        }
    }

    private void processColumns() {
        int n = MPPUtility.getInt(this.m_data, this.m_headerOffset);
        this.m_headerOffset += 4;
        this.m_dataOffset = MPPUtility.getInt(this.m_data, this.m_headerOffset);
        this.m_headerOffset += 4;
        FieldType fieldType = FieldTypeHelper.getInstance(n);
        if (fieldType.getDataType() != null) {
            this.processKnownType(fieldType);
        }
    }

    private void processKnownType(FieldType fieldType) {
        GraphicalIndicator graphicalIndicator = this.m_container.getCustomField(fieldType).getGraphicalIndicator();
        graphicalIndicator.setFieldType(fieldType);
        byte by = this.m_data[this.m_dataOffset];
        graphicalIndicator.setProjectSummaryInheritsFromSummaryRows((by & 8) != 0);
        graphicalIndicator.setSummaryRowsInheritFromNonSummaryRows((by & 4) != 0);
        graphicalIndicator.setDisplayGraphicalIndicators((by & 2) != 0);
        graphicalIndicator.setShowDataValuesInToolTips((by & 1) != 0);
        this.m_dataOffset += 20;
        int n = MPPUtility.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int n2 = MPPUtility.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int n3 = MPPUtility.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int n4 = MPPUtility.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int n5 = this.m_dataOffset + n2;
        int n6 = this.m_dataOffset + n3;
        int n7 = this.m_dataOffset + n4;
        this.m_dataOffset += n;
        while (this.m_dataOffset + 2 < n5) {
            graphicalIndicator.addNonSummaryRowCriteria(this.processCriteria(fieldType));
        }
        while (this.m_dataOffset + 2 < n6) {
            graphicalIndicator.addSummaryRowCriteria(this.processCriteria(fieldType));
        }
        while (this.m_dataOffset + 2 < n7) {
            graphicalIndicator.addProjectSummaryCriteria(this.processCriteria(fieldType));
        }
    }

    private GraphicalIndicatorCriteria processCriteria(FieldType fieldType) {
        GraphicalIndicatorCriteria graphicalIndicatorCriteria = new GraphicalIndicatorCriteria(this.m_properties);
        graphicalIndicatorCriteria.setLeftValue(fieldType);
        int n = MPPUtility.getInt(this.m_data, this.m_dataOffset);
        this.m_dataOffset += 4;
        graphicalIndicatorCriteria.setIndicator(n);
        if (this.m_dataOffset + 4 < this.m_data.length) {
            int n2 = MPPUtility.getInt(this.m_data, this.m_dataOffset);
            this.m_dataOffset += 4;
            TestOperator testOperator = n2 == 0 ? TestOperator.IS_ANY_VALUE : TestOperator.getInstance(n2 - 999);
            graphicalIndicatorCriteria.setOperator(testOperator);
            if (testOperator != TestOperator.IS_ANY_VALUE) {
                this.processOperandValue(0, fieldType, graphicalIndicatorCriteria);
                if (testOperator == TestOperator.IS_WITHIN || testOperator == TestOperator.IS_NOT_WITHIN) {
                    this.processOperandValue(1, fieldType, graphicalIndicatorCriteria);
                }
            }
        }
        return graphicalIndicatorCriteria;
    }

    private void processOperandValue(int n, FieldType fieldType, GraphicalIndicatorCriteria graphicalIndicatorCriteria) {
        boolean bl = MPPUtility.getInt(this.m_data, this.m_dataOffset) == 1;
        this.m_dataOffset += 4;
        if (!bl) {
            int n2 = MPPUtility.getInt(this.m_data, this.m_dataOffset);
            graphicalIndicatorCriteria.setRightValue(n, FieldTypeHelper.getInstance(n2));
            this.m_dataOffset += 4;
        } else {
            this.m_dataOffset += 2;
            switch (fieldType.getDataType()) {
                case DURATION: {
                    Duration duration = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(this.m_data, this.m_dataOffset), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(this.m_data, this.m_dataOffset + 4)));
                    this.m_dataOffset += 6;
                    graphicalIndicatorCriteria.setRightValue(n, duration);
                    break;
                }
                case NUMERIC: {
                    Double d = MPPUtility.getDouble(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += 8;
                    graphicalIndicatorCriteria.setRightValue(n, d);
                    break;
                }
                case CURRENCY: {
                    Double d = MPPUtility.getDouble(this.m_data, this.m_dataOffset) / 100.0;
                    this.m_dataOffset += 8;
                    graphicalIndicatorCriteria.setRightValue(n, d);
                    break;
                }
                case STRING: {
                    String string = MPPUtility.getUnicodeString(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += (string.length() + 1) * 2;
                    graphicalIndicatorCriteria.setRightValue(n, string);
                    break;
                }
                case BOOLEAN: {
                    int n3 = MPPUtility.getShort(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += 2;
                    graphicalIndicatorCriteria.setRightValue(n, n3 == 1 ? Boolean.TRUE : Boolean.FALSE);
                    break;
                }
                case DATE: {
                    Date date = MPPUtility.getTimestamp(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += 4;
                    graphicalIndicatorCriteria.setRightValue(n, date);
                    break;
                }
            }
        }
    }
}

