/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.sjs.ir;

import dotty.tools.sjs.ir.IRVersionNotSupportedException;
import dotty.tools.sjs.ir.VersionChecks$;
import java.util.concurrent.ConcurrentHashMap;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;

public class VersionChecks {
    private final String current;
    private final String binaryEmitted;
    private final int binaryMajor;
    private final int binaryMinor;
    private final Option<String> binaryPreRelease;
    private final String binaryCross;
    private final ConcurrentHashMap.KeySetView knownSupportedBinary;

    public VersionChecks(String current, String binaryEmitted) {
        this.current = current;
        this.binaryEmitted = binaryEmitted;
        VersionChecks$.MODULE$.dotty$tools$sjs$ir$VersionChecks$$$checkConsistent(current, binaryEmitted);
        Tuple3<Object, Object, Option<String>> tuple3 = VersionChecks$.MODULE$.dotty$tools$sjs$ir$VersionChecks$$$parseBinary(binaryEmitted);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Tuple3<Object, Object, Option<String>> $1$ = tuple3;
        Tuple3<Object, Object, Option<String>> tuple32 = $1$;
        this.binaryMajor = BoxesRunTime.unboxToInt((Object)tuple32._1());
        this.binaryMinor = BoxesRunTime.unboxToInt((Object)tuple32._2());
        this.binaryPreRelease = (Option)tuple32._3();
        boolean needsFull = this.binaryPreRelease.isDefined() && this.binaryMinor == 0;
        this.binaryCross = needsFull ? binaryEmitted : BoxesRunTime.boxToInteger((int)this.binaryMajor).toString();
        ConcurrentHashMap.KeySetView<String, Boolean> m = ConcurrentHashMap.newKeySet();
        m.add(binaryEmitted);
        this.knownSupportedBinary = m;
    }

    public final String current() {
        return this.current;
    }

    public final String binaryEmitted() {
        return this.binaryEmitted;
    }

    public final String binaryCross() {
        return this.binaryCross;
    }

    public final void checkSupported(String version) {
        if (!this.knownSupportedBinary.contains(version)) {
            boolean supported;
            Tuple3<Object, Object, Option<String>> tuple3 = VersionChecks$.MODULE$.dotty$tools$sjs$ir$VersionChecks$$$parseBinary(version);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Tuple3<Object, Object, Option<String>> $7$ = tuple3;
            Tuple3<Object, Object, Option<String>> tuple32 = $7$;
            int major = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int minor = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Option preRelease = (Option)tuple32._3();
            boolean bl = supported = preRelease.isEmpty() && major == this.binaryMajor && minor <= this.binaryMinor && (this.binaryPreRelease.isEmpty() || minor < this.binaryMinor);
            if (supported) {
                this.knownSupportedBinary.add(version);
                return;
            }
            throw new IRVersionNotSupportedException(version, this.binaryEmitted(), new StringBuilder(49).append("This version (").append(version).append(") of Scala.js IR is not supported. ").append(new StringBuilder(29).append("Supported versions are up to ").append(this.binaryEmitted()).toString()).toString());
        }
    }
}

