/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Set;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Endpoint;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.MultiDbConfig;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.builders.MultiDbClientBuilder;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.executors.CommandExecutor;
import redis.clients.jedis.mcf.MultiDbConnectionProvider;
import redis.clients.jedis.mcf.MultiDbPipeline;
import redis.clients.jedis.mcf.MultiDbTransaction;
import redis.clients.jedis.providers.ConnectionProvider;

@Experimental
public class MultiDbClient
extends UnifiedJedis {
    MultiDbClient(CommandExecutor commandExecutor, ConnectionProvider connectionProvider, CommandObjects commandObjects, RedisProtocol redisProtocol, Cache cache) {
        super(commandExecutor, connectionProvider, commandObjects, redisProtocol, cache);
    }

    private MultiDbConnectionProvider getMultiDbConnectionProvider() {
        return (MultiDbConnectionProvider)this.provider;
    }

    public void setActiveDatabase(Endpoint endpoint) {
        this.getMultiDbConnectionProvider().setActiveDatabase(endpoint);
    }

    public void addDatabase(MultiDbConfig.DatabaseConfig databaseConfig) {
        this.getMultiDbConnectionProvider().add(databaseConfig);
    }

    public void addDatabase(Endpoint endpoint, float weight, JedisClientConfig clientConfig) {
        MultiDbConfig.DatabaseConfig databaseConfig = MultiDbConfig.DatabaseConfig.builder(endpoint, clientConfig).weight(weight).build();
        this.getMultiDbConnectionProvider().add(databaseConfig);
    }

    public Set<Endpoint> getDatabaseEndpoints() {
        return this.getMultiDbConnectionProvider().getEndpoints();
    }

    public boolean isHealthy(Endpoint endpoint) {
        return this.getMultiDbConnectionProvider().isHealthy(endpoint);
    }

    public void removeDatabase(Endpoint endpoint) {
        this.getMultiDbConnectionProvider().remove(endpoint);
    }

    public void forceActiveDatabase(Endpoint endpoint, long forcedActiveDurationMs) {
        this.getMultiDbConnectionProvider().forceActiveDatabase(endpoint, forcedActiveDurationMs);
    }

    @Override
    public MultiDbPipeline pipelined() {
        return new MultiDbPipeline(this.getMultiDbConnectionProvider(), this.commandObjects);
    }

    @Override
    public MultiDbTransaction multi() {
        return new MultiDbTransaction((MultiDbConnectionProvider)this.provider, true, this.commandObjects);
    }

    @Override
    public MultiDbTransaction transaction(boolean doMulti) {
        if (this.provider == null) {
            throw new IllegalStateException("It is not allowed to create Transaction from this " + this.getClass());
        }
        return new MultiDbTransaction(this.getMultiDbConnectionProvider(), doMulti, this.commandObjects);
    }

    public Endpoint getActiveDatabaseEndpoint() {
        return this.getMultiDbConnectionProvider().getDatabase().getEndpoint();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends MultiDbClientBuilder<MultiDbClient> {
        @Override
        protected MultiDbClient createClient() {
            return new MultiDbClient(this.commandExecutor, this.connectionProvider, this.commandObjects, this.clientConfig.getRedisProtocol(), this.cache);
        }
    }
}

