/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.Error;
import com.networknt.schema.i18n.MessageSource;
import java.util.Locale;
import java.util.Map;

public class MessageSourceError {
    public static Builder builder(MessageSource messageSource, Map<String, String> errorMessage) {
        return new Builder(messageSource, errorMessage);
    }

    public static class Builder
    extends BuilderSupport<Builder> {
        public Builder(MessageSource messageSource, Map<String, String> errorMessage) {
            super(messageSource, errorMessage);
        }

        @Override
        public Builder self() {
            return this;
        }
    }

    public static abstract class BuilderSupport<S>
    extends Error.BuilderSupport<S> {
        private final MessageSource messageSource;
        private final Map<String, String> errorMessage;
        private Locale locale;

        public BuilderSupport(MessageSource messageSource, Map<String, String> errorMessage) {
            this.messageSource = messageSource;
            this.errorMessage = errorMessage;
        }

        @Override
        public Error build() {
            String messagePattern = null;
            if (this.errorMessage != null) {
                String specificMessagePattern;
                messagePattern = this.errorMessage.get("");
                if (this.details != null && this.details.get("property") != null && (specificMessagePattern = this.errorMessage.get(this.details.get("property"))) != null) {
                    messagePattern = specificMessagePattern;
                }
                if (messagePattern != null && !"".equals(messagePattern)) {
                    this.message = messagePattern;
                }
            }
            if (this.message == null && this.messageSupplier == null && this.messageFormatter == null) {
                this.messageFormatter = args -> this.messageSource.getMessage(this.messageKey, this.locale == null ? Locale.ROOT : this.locale, args);
            }
            return super.build();
        }

        public S locale(Locale locale) {
            this.locale = locale;
            return this.self();
        }
    }
}

