/*
 * Decompiled with CFR 0.152.
 */
package liquibase.analytics;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.analytics.AnalyticsBatch;
import liquibase.analytics.AnalyticsListener;
import liquibase.analytics.Event;
import liquibase.analytics.configuration.AnalyticsArgs;
import liquibase.analytics.configuration.AnalyticsConfigurationFactory;
import liquibase.analytics.configuration.LiquibaseRemoteAnalyticsConfiguration;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.logging.Logger;
import liquibase.serializer.core.yaml.YamlSerializer;
import liquibase.util.ExceptionUtil;
import liquibase.util.LiquibaseUtil;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.nodes.Tag;

public class LiquibaseAnalyticsListener
implements AnalyticsListener {
    private final List<Event> cachedEvents = new ArrayList<Event>();
    private final AtomicBoolean addedShutdownHook = new AtomicBoolean(false);

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public void handleEvent(Event event) throws Exception {
        if (this.isEnabled()) {
            this.addSendEventsOnShutdownHook();
            this.cachedEvents.add(event);
            Integer maxCacheSize = Scope.getCurrentScope().get((Enum)Scope.Attr.maxAnalyticsCacheSize, Integer.valueOf(this.getDefaultMaxAnalyticsCacheSize(event)));
            if (this.cachedEvents.size() >= maxCacheSize) {
                this.flush();
            } else {
                Scope.getCurrentScope().getLog(this.getClass()).log(AnalyticsArgs.LOG_LEVEL.getCurrentValue(), "Caching analytics event to send later. Cache contains " + this.cachedEvents.size() + " event(s).", null);
            }
        }
    }

    private void addSendEventsOnShutdownHook() {
        if (!this.addedShutdownHook.getAndSet(true)) {
            Thread haltedHook = new Thread(() -> {
                Scope.getCurrentScope().getLog(this.getClass()).fine("Sending " + this.cachedEvents.size() + " cached analytics events during shutdown hook");
                try {
                    this.flush();
                }
                catch (Exception e) {
                    Scope.getCurrentScope().getLog(this.getClass()).warning("Failed to send analytics events during shutdown hook.", e);
                }
            });
            Runtime.getRuntime().addShutdownHook(haltedHook);
        }
    }

    private int getDefaultMaxAnalyticsCacheSize(Event event) {
        if (event != null && StringUtils.equals((CharSequence)event.getLiquibaseInterface(), (CharSequence)"JavaAPI")) {
            return 10;
        }
        return 1;
    }

    private synchronized void flush() throws Exception {
        AnalyticsConfigurationFactory analyticsConfigurationFactory = Scope.getCurrentScope().getSingleton(AnalyticsConfigurationFactory.class);
        LiquibaseRemoteAnalyticsConfiguration analyticsConfiguration = (LiquibaseRemoteAnalyticsConfiguration)analyticsConfigurationFactory.getPlugin();
        int timeoutMillis = analyticsConfiguration.getTimeoutMillis();
        Level logLevel = AnalyticsArgs.LOG_LEVEL.getCurrentValue();
        Logger logger = Scope.getCurrentScope().getLog(AnalyticsListener.class);
        LicenseService licenseService = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService();
        String userId = ExceptionUtil.doSilently(() -> {
            Object issuedTo = licenseService.getLicenseInfoObject().getIssuedTo();
            if (StringUtils.isNotEmpty((CharSequence)issuedTo)) {
                issuedTo = (String)issuedTo + "-" + StringUtils.right((String)licenseService.getLicenseKey().getValue(), (int)AnalyticsArgs.LICENSE_KEY_CHARS.getCurrentValue());
            }
            return issuedTo;
        });
        try {
            AnalyticsBatch analyticsBatch = AnalyticsBatch.fromLiquibaseEvent(this.cachedEvents, userId);
            LiquibaseAnalyticsListener.sendEvent(analyticsBatch, new URL(analyticsConfiguration.getDestinationUrl()), logger, logLevel, "Sending anonymous data to Liquibase analytics endpoint. ", "Response from Liquibase analytics endpoint: ", analyticsConfiguration.getTimeoutMillis(), analyticsConfiguration.getTimeoutMillis());
        }
        catch (Exception e) {
            if (e instanceof SocketTimeoutException) {
                logger.log(logLevel, "Timed out while waiting for analytics event processing.", null);
            }
            throw e;
        }
        this.cachedEvents.clear();
    }

    public static void sendEvent(Object requestBody, URL url, Logger logger, Level logLevel, String sendingLogMessage, String responseLogMessage, int connectTimeout, int readTimeout) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; utf-8");
        conn.setRequestProperty("Accept", "application/json");
        conn.setDoOutput(true);
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        dumperOptions.setWidth(Integer.MAX_VALUE);
        dumperOptions.setPrettyFlow(true);
        Yaml yaml = new Yaml(dumperOptions);
        yaml.setBeanAccess(BeanAccess.FIELD);
        String jsonInputString = YamlSerializer.removeClassTypeMarksFromSerializedJson(yaml.dumpAs(requestBody, Tag.MAP, DumperOptions.FlowStyle.FLOW));
        logger.log(logLevel, sendingLogMessage + System.lineSeparator() + jsonInputString, null);
        IOUtils.write((String)jsonInputString, (OutputStream)conn.getOutputStream(), (Charset)StandardCharsets.UTF_8);
        int responseCode = conn.getResponseCode();
        String responseBody = ExceptionUtil.doSilently(() -> IOUtils.toString((InputStream)conn.getInputStream()));
        logger.log(logLevel, responseLogMessage + responseCode + " " + responseBody, null);
        conn.disconnect();
    }

    @Override
    public boolean isEnabled() {
        Logger log = Scope.getCurrentScope().getLog(AnalyticsArgs.class);
        if (!this.isDevAnalyticsEnabled(log)) {
            return false;
        }
        Boolean userSuppliedEnabled = this.didUserEnableAnalytics(log);
        if (Boolean.FALSE.equals(userSuppliedEnabled)) {
            return false;
        }
        return this.isAnalyticsEnabledBasedOnLicense(log, userSuppliedEnabled);
    }

    protected Boolean didUserEnableAnalytics(Logger log) {
        Boolean userSuppliedEnabled = AnalyticsArgs.ENABLED.getCurrentValue();
        if (Boolean.FALSE.equals(userSuppliedEnabled)) {
            log.log(AnalyticsArgs.LOG_LEVEL.getCurrentValue(), "User has disabled analytics.", null);
            return false;
        }
        return userSuppliedEnabled;
    }

    protected boolean isDevAnalyticsEnabled(Logger log) {
        Boolean devOverride = AnalyticsArgs.DEV_OVERRIDE.getCurrentValue();
        if (LiquibaseUtil.isDevVersion() && Boolean.FALSE.equals(devOverride)) {
            log.severe("Analytics is disabled because this is not a release build and the user has not provided a value for the " + AnalyticsArgs.DEV_OVERRIDE.getKey() + " option.");
            return false;
        }
        String configEndpointUrl = AnalyticsArgs.CONFIG_ENDPOINT_URL.getCurrentValue();
        if (Boolean.TRUE.equals(devOverride) && AnalyticsArgs.CONFIG_ENDPOINT_URL.getDefaultValue().equals(configEndpointUrl)) {
            log.severe("Analytics is disabled because " + AnalyticsArgs.DEV_OVERRIDE.getKey() + " was set to true, but the default value was used for the " + AnalyticsArgs.CONFIG_ENDPOINT_URL.getKey() + " property. This is not permitted, because dev versions of Liquibase should not be pushing analytics towards the prod analytics stack. To resolve this, provide a value for " + AnalyticsArgs.CONFIG_ENDPOINT_URL.getKey() + " that is not the default value.");
            return false;
        }
        return true;
    }

    protected boolean isAnalyticsEnabledBasedOnLicense(Logger log, Boolean userSuppliedEnabled) {
        boolean proLicenseValid = LicenseServiceUtils.isProLicenseValid();
        AnalyticsConfigurationFactory analyticsConfigurationFactory = Scope.getCurrentScope().getSingleton(AnalyticsConfigurationFactory.class);
        if (proLicenseValid) {
            if (Boolean.TRUE.equals(userSuppliedEnabled)) {
                boolean enabled = this.isProRemoteAnalyticsEnabled(analyticsConfigurationFactory);
                if (Boolean.FALSE.equals(enabled)) {
                    log.log(AnalyticsArgs.LOG_LEVEL.getCurrentValue(), "Analytics is disabled, because a license was detected and analytics was not enabled by the user or because it was turned off by Liquibase.", null);
                }
                return enabled;
            }
            return false;
        }
        boolean enabled = LiquibaseAnalyticsListener.isOssRemoteAnalyticsEnabled(analyticsConfigurationFactory);
        if (Boolean.FALSE.equals(enabled)) {
            log.log(AnalyticsArgs.LOG_LEVEL.getCurrentValue(), "Analytics is disabled, because it was turned off by Liquibase.", null);
        }
        return enabled;
    }

    protected static boolean isOssRemoteAnalyticsEnabled(AnalyticsConfigurationFactory analyticsConfigurationFactory) {
        boolean enabled;
        try {
            enabled = analyticsConfigurationFactory.getPlugin().isOssAnalyticsEnabled();
        }
        catch (Exception couldNotDetermineRemoteAnalytics) {
            enabled = false;
        }
        return enabled;
    }

    protected boolean isProRemoteAnalyticsEnabled(AnalyticsConfigurationFactory analyticsConfigurationFactory) {
        boolean enabled;
        try {
            enabled = analyticsConfigurationFactory.getPlugin().isProAnalyticsEnabled();
        }
        catch (Exception couldNotDetermineRemoteAnalytics) {
            enabled = false;
        }
        return enabled;
    }

    @Generated
    public LiquibaseAnalyticsListener() {
    }
}

