/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.cpu;

import java.util.Map;
import java.util.Properties;
import org.graalvm.visualvm.sampler.SamplerParameters;

public final class CPUSamplerParameters
extends SamplerParameters {
    static final String INCLUDE_PACKAGES = "include-classes";
    static final String EXCLUDE_PACKAGES = "exclude-classes";
    static final String SAMPLING_RATE = "sampling-rate";

    private CPUSamplerParameters(String parametersS) {
        super(parametersS);
    }

    public static CPUSamplerParameters parse(String parameters) {
        return new CPUSamplerParameters(parameters);
    }

    @Override
    protected void parseParameters(String parametersS, Map<String, String> parameters) {
        if (parametersS.startsWith("settings-file=")) {
            this.parseParametersFile(CPUSamplerParameters.decode(parametersS.substring("settings-file".length() + 1)), parameters);
        } else {
            for (String parameter : parametersS.split(",")) {
                int idx = parameter.indexOf("include-classes=");
                if (idx == 0) {
                    parameters.put(INCLUDE_PACKAGES, CPUSamplerParameters.decode(parameter.substring(INCLUDE_PACKAGES.length() + 1)));
                }
                if ((idx = parameter.indexOf("exclude-classes=")) == 0) {
                    parameters.put(EXCLUDE_PACKAGES, CPUSamplerParameters.decode(parameter.substring(EXCLUDE_PACKAGES.length() + 1)));
                }
                if ((idx = parameter.indexOf("sampling-rate=")) != 0) continue;
                parameters.put(SAMPLING_RATE, CPUSamplerParameters.decode(parameter.substring(SAMPLING_RATE.length() + 1)));
            }
        }
    }

    private void parseParametersFile(String file, Map<String, String> parameters) {
        Properties properties = CPUSamplerParameters.loadProperties(file);
        String prop = properties.getProperty(INCLUDE_PACKAGES);
        if (prop != null) {
            parameters.put(INCLUDE_PACKAGES, CPUSamplerParameters.decode(prop));
        }
        if ((prop = properties.getProperty(EXCLUDE_PACKAGES)) != null) {
            parameters.put(EXCLUDE_PACKAGES, CPUSamplerParameters.decode(prop));
        }
        if ((prop = properties.getProperty(SAMPLING_RATE)) != null) {
            parameters.put(SAMPLING_RATE, CPUSamplerParameters.decode(prop));
        }
    }
}

