/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.atsc;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.atsc.ATSCStyle;
import org.w3c.css.properties.atsc.CssBackgroundATSC;
import org.w3c.css.properties.css.CssBackgroundConstants;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssBackgroundAttachmentATSC
extends CssProperty
implements CssBackgroundConstants {
    int attachment;
    private static int[] hash_values = new int[ATTACHMENT.length];

    public CssBackgroundAttachmentATSC() {
    }

    public CssBackgroundAttachmentATSC(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        if (val instanceof CssIdent) {
            int hash = val.hashCode();
            for (int i = 0; i < ATTACHMENT.length; ++i) {
                if (hash_values[i] != hash) continue;
                this.attachment = i;
                expression.next();
                return;
            }
        }
        throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
    }

    public CssBackgroundAttachmentATSC(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public Object get() {
        return ATTACHMENT[this.attachment];
    }

    @Override
    public boolean isSoftlyInherited() {
        return this.attachment == 2;
    }

    @Override
    public String toString() {
        return ATTACHMENT[this.attachment];
    }

    @Override
    public String getPropertyName() {
        return "background-attachment";
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        CssBackgroundATSC cssBackground = ((ATSCStyle)style).cssBackgroundATSC;
        if (cssBackground.attachment != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssBackground.attachment = this;
    }

    @Override
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((ATSCStyle)style).getBackgroundAttachmentATSC();
        }
        return ((ATSCStyle)style).cssBackgroundATSC.attachment;
    }

    @Override
    public boolean equals(CssProperty property) {
        return property instanceof CssBackgroundAttachmentATSC && this.attachment == ((CssBackgroundAttachmentATSC)property).attachment;
    }

    @Override
    public boolean isDefault() {
        return this.attachment == 0;
    }

    static {
        for (int i = 0; i < ATTACHMENT.length; ++i) {
            CssBackgroundAttachmentATSC.hash_values[i] = ATTACHMENT[i].hashCode();
        }
    }
}

