/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.job;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJobRunner;
import org.pentaho.di.job.entries.job.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.StepLoader;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryJob
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static final LogWriter log = LogWriter.getInstance();
    private String jobname;
    private String filename;
    private String directory;
    public String[] arguments;
    public boolean argFromPrevious;
    public boolean paramsFromPrevious;
    public boolean execPerRow;
    public String[] parameters;
    public String[] parameterFieldNames;
    public String[] parameterValues;
    public boolean setLogfile;
    public String logfile;
    public String logext;
    public boolean addDate;
    public boolean addTime;
    public int loglevel;
    public boolean parallel;
    private String directoryPath;
    public boolean setAppendLogfile;
    public boolean waitingToFinish = true;
    public boolean followingAbortRemotely;
    private String remoteSlaveServerName;
    public boolean passingAllParameters = true;

    public JobEntryJob(String name) {
        super(name, "");
        this.setJobEntryType(JobEntryType.JOB);
    }

    public JobEntryJob() {
        this("");
        this.clear();
    }

    @Override
    public Object clone() {
        JobEntryJob je = (JobEntryJob)super.clone();
        return je;
    }

    public JobEntryJob(JobEntryBase jeb) {
        super(jeb);
    }

    public void setFileName(String n) {
        this.filename = n;
    }

    public String getFileName() {
        return this.filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    public void setJobName(String jobname) {
        this.jobname = jobname;
    }

    public String getJobName() {
        return this.jobname;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getLogFilename() {
        String retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = retval + this.logfile;
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = retval + "." + this.logext;
            }
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"jobname", (String)this.jobname));
        if (this.directory != null) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directory));
        } else if (this.directoryPath != null) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directoryPath));
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"params_from_previous", (boolean)this.paramsFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"exec_per_row", (boolean)this.execPerRow));
        retval.append("      ").append(XMLHandler.addTagValue((String)"set_logfile", (boolean)this.setLogfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logfile", (String)this.logfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logext", (String)this.logext));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.addDate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.addTime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"loglevel", (String)LogWriter.getLogLevelDesc((int)this.loglevel)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"slave_server_name", (String)this.remoteSlaveServerName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wait_until_finished", (boolean)this.waitingToFinish));
        retval.append("      ").append(XMLHandler.addTagValue((String)"follow_abort_remote", (boolean)this.followingAbortRemotely));
        if (this.arguments != null) {
            for (i = 0; i < this.arguments.length; ++i) {
                retval.append("      ").append(XMLHandler.addTagValue((String)("argument" + i), (String)this.arguments[i]));
            }
        }
        if (this.parameters != null) {
            retval.append("      ").append(XMLHandler.openTag((String)"parameters"));
            retval.append("        ").append(XMLHandler.addTagValue((String)"pass_all_parameters", (boolean)this.passingAllParameters));
            for (i = 0; i < this.parameters.length; ++i) {
                retval.append("            ").append(XMLHandler.openTag((String)"parameter"));
                retval.append("            ").append(XMLHandler.addTagValue((String)"name", (String)this.parameters[i]));
                retval.append("            ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.parameterFieldNames[i]));
                retval.append("            ").append(XMLHandler.addTagValue((String)"value", (String)this.parameterValues[i]));
                retval.append("            ").append(XMLHandler.closeTag((String)"parameter"));
            }
            retval.append("      ").append(XMLHandler.closeTag((String)"parameters"));
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"set_append_logfile", (boolean)this.setAppendLogfile));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.setFileName(XMLHandler.getTagValue((Node)entrynode, (String)"filename"));
            this.setJobName(XMLHandler.getTagValue((Node)entrynode, (String)"jobname"));
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.paramsFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"params_from_previous"));
            this.execPerRow = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"exec_per_row"));
            this.setLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"set_logfile"));
            this.addDate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.addTime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.logfile = XMLHandler.getTagValue((Node)entrynode, (String)"logfile");
            this.logext = XMLHandler.getTagValue((Node)entrynode, (String)"logext");
            this.loglevel = LogWriter.getLogLevel((String)XMLHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.setAppendLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"set_append_logfile"));
            this.remoteSlaveServerName = XMLHandler.getTagValue((Node)entrynode, (String)"slave_server_name");
            this.directory = XMLHandler.getTagValue((Node)entrynode, (String)"directory");
            String wait = XMLHandler.getTagValue((Node)entrynode, (String)"wait_until_finished");
            this.waitingToFinish = Const.isEmpty((String)wait) ? true : "Y".equalsIgnoreCase(wait);
            this.followingAbortRemotely = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"follow_abort_remote"));
            int argnr = 0;
            while (XMLHandler.getTagValue((Node)entrynode, (String)("argument" + argnr)) != null) {
                ++argnr;
            }
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = XMLHandler.getTagValue((Node)entrynode, (String)("argument" + a));
            }
            Node parametersNode = XMLHandler.getSubNode((Node)entrynode, (String)"parameters");
            String passAll = XMLHandler.getTagValue((Node)parametersNode, (String)"pass_all_parameters");
            this.passingAllParameters = Const.isEmpty((String)passAll) || "Y".equalsIgnoreCase(passAll);
            int nrParameters = XMLHandler.countNodes((Node)parametersNode, (String)"parameter");
            this.parameters = new String[nrParameters];
            this.parameterFieldNames = new String[nrParameters];
            this.parameterValues = new String[nrParameters];
            for (int i = 0; i < nrParameters; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)parametersNode, (String)"parameter", (int)i);
                this.parameters[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.parameterFieldNames[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_name");
                this.parameterValues[i] = XMLHandler.getTagValue((Node)knode, (String)"value");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load 'job' job entry from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.jobname = rep.getJobEntryAttributeString(id_jobentry, "name");
            this.directory = rep.getJobEntryAttributeString(id_jobentry, "dir_path");
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "file_name");
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.paramsFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "params_from_previous");
            this.execPerRow = rep.getJobEntryAttributeBoolean(id_jobentry, "exec_per_row");
            this.setLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_logfile");
            this.addDate = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.addTime = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.logfile = rep.getJobEntryAttributeString(id_jobentry, "logfile");
            this.logext = rep.getJobEntryAttributeString(id_jobentry, "logext");
            this.loglevel = LogWriter.getLogLevel((String)rep.getJobEntryAttributeString(id_jobentry, "loglevel"));
            this.setAppendLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_append_logfile");
            this.remoteSlaveServerName = rep.getJobEntryAttributeString(id_jobentry, "slave_server_name");
            this.waitingToFinish = rep.getJobEntryAttributeBoolean(id_jobentry, "wait_until_finished", true);
            this.followingAbortRemotely = rep.getJobEntryAttributeBoolean(id_jobentry, "follow_abort_remote");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "argument");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "argument");
            }
            int parameternr = rep.countNrJobEntryAttributes(id_jobentry, "parameter_name");
            this.parameters = new String[parameternr];
            this.parameterFieldNames = new String[parameternr];
            this.parameterValues = new String[parameternr];
            for (int a = 0; a < parameternr; ++a) {
                this.parameters[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_name");
                this.parameterFieldNames[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_stream_name");
                this.parameterValues[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_value");
            }
            this.passingAllParameters = rep.getJobEntryAttributeBoolean(id_jobentry, "pass_all_parameters", true);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'job' from the repository with id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            int i;
            super.saveRep(rep, id_job);
            if (rep.getImportBaseDirectory() != null && !rep.getImportBaseDirectory().isRoot()) {
                this.directory = rep.getImportBaseDirectory().getPath() + this.directoryPath;
            }
            if (this.directory == null) {
                this.directory = rep.getImportBaseDirectory() != null ? rep.getImportBaseDirectory().getPath() : new RepositoryDirectory().getPath();
            }
            rep.saveJobEntryAttribute(id_job, this.getID(), "name", this.getJobName());
            rep.saveJobEntryAttribute(id_job, this.getID(), "dir_path", this.getDirectory() != null ? this.getDirectory() : "");
            rep.saveJobEntryAttribute(id_job, this.getID(), "file_name", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "params_from_previous", this.paramsFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "exec_per_row", this.execPerRow);
            rep.saveJobEntryAttribute(id_job, this.getID(), "set_logfile", this.setLogfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_date", this.addDate);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_time", this.addTime);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logfile", this.logfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logext", this.logext);
            rep.saveJobEntryAttribute(id_job, this.getID(), "set_append_logfile", this.setAppendLogfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "loglevel", LogWriter.getLogLevelDesc((int)this.loglevel));
            rep.saveJobEntryAttribute(id_job, this.getID(), "slave_server_name", this.remoteSlaveServerName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wait_until_finished", this.waitingToFinish);
            rep.saveJobEntryAttribute(id_job, this.getID(), "follow_abort_remote", this.followingAbortRemotely);
            if (this.arguments != null) {
                for (i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "argument", this.arguments[i]);
                }
            }
            if (this.parameters != null) {
                for (i = 0; i < this.parameters.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "parameter_name", this.parameters[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "parameter_stream_name", Const.NVL((String)this.parameterFieldNames[i], (String)""));
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "parameter_value", Const.NVL((String)this.parameterValues[i], (String)""));
                }
            }
            rep.saveJobEntryAttribute(id_job, this.getID(), "pass_all_parameters", this.passingAllParameters);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type job to the repository with id_job=" + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result result, int nr, Repository rep, Job parentJob) throws KettleException {
        result.setEntryNr((long)nr);
        LogWriter logwriter = log;
        Log4jFileAppender appender = null;
        int backupLogLevel = log.getLogLevel();
        if (this.setLogfile) {
            try {
                appender = LogWriter.createFileAppender((String)this.environmentSubstitute(this.getLogFilename()), (boolean)true, (boolean)this.setAppendLogfile);
            }
            catch (KettleException e) {
                log.logError(this.toString(), "Unable to open file appender for file [" + this.getLogFilename() + "] : " + e.toString(), new Object[0]);
                log.logError(this.toString(), Const.getStackTracker((Throwable)e), new Object[0]);
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            log.addAppender((Appender)appender);
            log.setLogLevel(this.loglevel);
            logwriter = LogWriter.getInstance((String)this.environmentSubstitute(this.getLogFilename()), (boolean)true, (int)this.loglevel);
        }
        SlaveServer remoteSlaveServer = null;
        if (!Const.isEmpty((String)this.remoteSlaveServerName)) {
            String realRemoteSlaveServerName = this.environmentSubstitute(this.remoteSlaveServerName);
            remoteSlaveServer = parentJob.getJobMeta().findSlaveServer(realRemoteSlaveServerName);
            if (remoteSlaveServer == null) {
                throw new KettleException(Messages.getString("JobJob.Exception.UnableToFindRemoteSlaveServer", realRemoteSlaveServerName));
            }
        }
        try {
            boolean fromXMLFile;
            if (parentJob.getJobMeta() != null) {
                parentJob.getJobMeta().setInternalKettleVariables();
            }
            JobMeta jobMeta = null;
            boolean fromRepository = rep != null && !Const.isEmpty((String)this.jobname) && this.directory != null;
            boolean bl = fromXMLFile = !Const.isEmpty((String)this.filename);
            if (fromRepository) {
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), "Loading job from repository : [" + this.directory + " : " + this.environmentSubstitute(this.jobname) + "]", new Object[0]);
                }
                jobMeta = new JobMeta(logwriter, rep, this.environmentSubstitute(this.jobname), rep.getDirectoryTree().findDirectory(this.environmentSubstitute(this.directory)));
                jobMeta.setParentVariableSpace(parentJob);
            } else if (fromXMLFile) {
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), "Loading job from XML file : [" + this.environmentSubstitute(this.filename) + "]", new Object[0]);
                }
                jobMeta = new JobMeta(logwriter, this.environmentSubstitute(this.filename), rep, null);
                jobMeta.setParentVariableSpace(parentJob);
            }
            if (jobMeta == null) {
                throw new KettleException("Unable to load the job: please specify the name and repository directory OR a filename");
            }
            this.verifyRecursiveExecution(parentJob, jobMeta);
            if (fromRepository) {
                if (log.isBasic()) {
                    log.logBasic(this.toString(), "Starting job, loaded from repository : [" + this.directory + " : " + this.environmentSubstitute(this.jobname) + "]", new Object[0]);
                }
            } else if (fromXMLFile && log.isDetailed()) {
                log.logDetailed(this.toString(), "Starting job, loaded from XML file : [" + this.environmentSubstitute(this.filename) + "]", new Object[0]);
            }
            int iteration = 0;
            String[] args1 = this.arguments;
            if (args1 == null || args1.length == 0) {
                args1 = parentJob.getJobMeta().getArguments();
            }
            this.copyVariablesFrom(parentJob);
            this.setParentVariableSpace(parentJob);
            String[] args = null;
            if (args1 != null) {
                args = new String[args1.length];
                for (int idx = 0; idx < args1.length; ++idx) {
                    args[idx] = this.environmentSubstitute(args1[idx]);
                }
            }
            NamedParamsDefault namedParam = new NamedParamsDefault();
            if (this.parameters != null) {
                for (int idx = 0; idx < this.parameters.length; ++idx) {
                    if (Const.isEmpty((String)this.parameters[idx])) continue;
                    try {
                        namedParam.addParameterDefinition(this.parameters[idx], "", "Job entry runtime");
                    }
                    catch (DuplicateParamException e) {
                        log.logError(this.toString(), "Duplicate parameter definition for " + this.parameters[idx], new Object[0]);
                    }
                    if (Const.isEmpty((String)Const.trim((String)this.parameterFieldNames[idx]))) {
                        namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)""));
                        continue;
                    }
                    namedParam.setParameterValue(this.parameters[idx], "");
                }
            }
            RowMetaAndData resultRow = null;
            boolean first = true;
            ArrayList rows = new ArrayList(result.getRows());
            while (first && !this.execPerRow || this.execPerRow && rows != null && iteration < rows.size() && result.getNrErrors() == 0L) {
                Result oneResult;
                block77: {
                    String fieldValue;
                    if (this.execPerRow) {
                        result.getRows().clear();
                    }
                    first = false;
                    resultRow = rows != null && this.execPerRow ? (RowMetaAndData)rows.get(iteration) : null;
                    oneResult = new Result();
                    ArrayList<RowMetaAndData> sourceRows = null;
                    if (this.execPerRow) {
                        if (this.argFromPrevious) {
                            args = null;
                            if (resultRow != null) {
                                args = new String[resultRow.size()];
                                for (int i = 0; i < resultRow.size(); ++i) {
                                    args[i] = resultRow.getString(i, null);
                                }
                            }
                        } else {
                            ArrayList<RowMetaAndData> newList = new ArrayList<RowMetaAndData>();
                            newList.add(resultRow);
                            sourceRows = newList;
                        }
                        if (this.paramsFromPrevious && this.parameters != null) {
                            for (int idx = 0; idx < this.parameters.length; ++idx) {
                                if (Const.isEmpty((String)this.parameters[idx])) continue;
                                if (Const.isEmpty((String)Const.trim((String)this.parameterFieldNames[idx]))) {
                                    namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)""));
                                    continue;
                                }
                                fieldValue = "";
                                if (resultRow != null) {
                                    fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                                }
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                            }
                        }
                    } else {
                        if (this.argFromPrevious) {
                            args = null;
                            if (resultRow != null) {
                                args = new String[resultRow.size()];
                                for (int i = 0; i < resultRow.size(); ++i) {
                                    args[i] = resultRow.getString(i, null);
                                }
                            }
                        } else {
                            sourceRows = result.getRows();
                        }
                        if (this.paramsFromPrevious && this.parameters != null) {
                            for (int idx = 0; idx < this.parameters.length; ++idx) {
                                if (Const.isEmpty((String)this.parameters[idx])) continue;
                                if (Const.isEmpty((String)Const.trim((String)this.parameterFieldNames[idx]))) {
                                    namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)""));
                                    continue;
                                }
                                fieldValue = "";
                                if (resultRow != null) {
                                    fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                                }
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                            }
                        }
                    }
                    if (remoteSlaveServer == null) {
                        Job job = new Job(logwriter, StepLoader.getInstance(), rep, jobMeta);
                        job.shareVariablesWith(this);
                        job.setInternalKettleVariables(this);
                        job.copyParametersFrom(jobMeta);
                        job.setSocketRepository(parentJob.getSocketRepository());
                        job.clearParameters();
                        String[] parameterNames = job.listParameters();
                        for (int idx = 0; idx < parameterNames.length; ++idx) {
                            String parentValue;
                            String thisValue = namedParam.getParameterValue(parameterNames[idx]);
                            if (!Const.isEmpty((String)thisValue)) {
                                job.setParameterValue(parameterNames[idx], thisValue);
                                continue;
                            }
                            if (!this.isPassingAllParameters() || Const.isEmpty((String)(parentValue = parentJob.getParameterValue(parameterNames[idx])))) continue;
                            job.setParameterValue(parameterNames[idx], parentValue);
                        }
                        job.activateParameters();
                        job.setSourceRows(sourceRows);
                        job.beginProcessing();
                        parentJob.getJobTracker().addJobTracker(job.getJobTracker());
                        job.getJobTracker().setParentJobTracker(parentJob.getJobTracker());
                        job.setParentJob(parentJob);
                        if (parentJob.getJobMeta().isBatchIdPassed()) {
                            job.setPassedBatchId(parentJob.getBatchId());
                        }
                        job.getJobMeta().setArguments(args);
                        JobEntryJobRunner runner = new JobEntryJobRunner(job, result, nr);
                        Thread jobRunnerThread = new Thread(runner);
                        jobRunnerThread.setName(Const.NVL((String)job.getJobMeta().getName(), (String)job.getJobMeta().getFilename()));
                        jobRunnerThread.start();
                        try {
                            while (!runner.isFinished() && !parentJob.isStopped()) {
                                try {
                                    Thread.sleep(0L, 1);
                                }
                                catch (InterruptedException e) {}
                            }
                            if (parentJob.isStopped()) {
                                job.stopAll();
                                runner.waitUntilFinished();
                                job.endProcessing("stop", new Result());
                            } else {
                                job.endProcessing("end", runner.getResult());
                            }
                        }
                        catch (KettleException je) {
                            log.logError(this.toString(), "Unable to open job entry job with name [" + this.getName() + "] : " + Const.CR + je.toString(), new Object[0]);
                            result.setNrErrors(1L);
                        }
                        oneResult = runner.getResult();
                    } else {
                        JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration();
                        jobExecutionConfiguration.setPreviousResult(result.clone());
                        jobExecutionConfiguration.getPreviousResult().setRows(sourceRows);
                        jobExecutionConfiguration.setArgumentStrings(args);
                        jobExecutionConfiguration.setVariables(this);
                        jobExecutionConfiguration.setRemoteServer(remoteSlaveServer);
                        jobExecutionConfiguration.setRepository(rep);
                        jobExecutionConfiguration.setLogLevel(log.getLogLevel());
                        try {
                            Job.sendToSlaveServer(jobMeta, jobExecutionConfiguration, rep);
                        }
                        catch (KettleException e) {
                            parentJob.stopAll();
                            throw e;
                        }
                        SlaveServerJobStatus jobStatus = null;
                        while (!parentJob.isStopped() && this.waitingToFinish) {
                            block76: {
                                try {
                                    jobStatus = remoteSlaveServer.getJobStatus(jobMeta.getName());
                                    if (jobStatus.getResult() != null) {
                                        oneResult = jobStatus.getResult();
                                    }
                                    break block76;
                                }
                                catch (Exception e1) {
                                    log.logError(this.toString(), "Unable to contact slave server [" + remoteSlaveServer + "] to verify the status of job [" + jobMeta.getName() + "]", new Object[0]);
                                    oneResult.setNrErrors(1L);
                                }
                                break;
                            }
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException e) {}
                        }
                        if (!this.waitingToFinish) {
                            oneResult = new Result();
                            oneResult.setResult(true);
                        }
                        if (parentJob.isStopped()) {
                            try {
                                if (jobStatus != null && !jobStatus.isRunning()) break block77;
                                remoteSlaveServer.stopJob(jobMeta.getName());
                            }
                            catch (Exception e1) {
                                log.logError(this.toString(), "Unable to contact slave server [" + remoteSlaveServer + "] to stop job [" + jobMeta.getName() + "]", new Object[0]);
                                oneResult.setNrErrors(1L);
                                break;
                            }
                        }
                    }
                }
                if (iteration == 0) {
                    result.clear();
                }
                result.add(oneResult);
                if (!oneResult.getResult()) {
                    result.setNrErrors(result.getNrErrors() + 1L);
                }
                ++iteration;
            }
        }
        catch (KettleException ke) {
            log.logError(this.toString(), "Error running job entry 'job' : " + ke.toString(), new Object[0]);
            log.logError(this.toString(), Const.getStackTracker((Throwable)ke), new Object[0]);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        if (this.setLogfile) {
            if (appender != null) {
                log.removeAppender((Appender)appender);
                appender.close();
                ResultFile resultFile = new ResultFile(1, appender.getFile(), parentJob.getJobname(), this.getName());
                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            }
            log.setLogLevel(backupLogLevel);
        }
        if (result.getNrErrors() > 0L) {
            result.setResult(false);
        } else {
            result.setResult(true);
        }
        return result;
    }

    private void verifyRecursiveExecution(Job parentJob, JobMeta jobMeta) throws KettleException {
        if (parentJob == null) {
            return;
        }
        JobMeta parentJobMeta = parentJob.getJobMeta();
        if (parentJobMeta.getName() == null && jobMeta.getName() != null) {
            return;
        }
        if (parentJobMeta.getName() != null && jobMeta.getName() == null) {
            return;
        }
        if (jobMeta.getFilename() != null && jobMeta.getFilename().equals(parentJobMeta.getFilename())) {
            throw new KettleException(Messages.getString("JobJobError.Recursive", jobMeta.getFilename()));
        }
        if (parentJobMeta.getDirectory() == null && jobMeta.getDirectory() != null) {
            return;
        }
        if (parentJobMeta.getDirectory() != null && jobMeta.getDirectory() == null) {
            return;
        }
        if (jobMeta.getDirectory().getID() != parentJobMeta.getDirectory().getID()) {
            return;
        }
        if (parentJobMeta.getName().equals(jobMeta.getName())) {
            throw new KettleException(Messages.getString("JobJobError.Recursive", jobMeta.getFilename()));
        }
        this.verifyRecursiveExecution(parentJob.getParentJob(), jobMeta);
    }

    @Override
    public void clear() {
        super.clear();
        this.jobname = null;
        this.filename = null;
        this.directory = null;
        this.arguments = null;
        this.argFromPrevious = false;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
        this.setAppendLogfile = false;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public List<SQLStatement> getSQLStatements(Repository repository) throws KettleException {
        return this.getSQLStatements(repository, null);
    }

    @Override
    public List<SQLStatement> getSQLStatements(Repository repository, VariableSpace space) throws KettleException {
        this.copyVariablesFrom(space);
        JobMeta jobMeta = this.getJobMeta(repository, space);
        return jobMeta.getSQLStatements(repository, null);
    }

    private JobMeta getJobMeta(Repository rep, VariableSpace space) throws KettleException {
        try {
            if (rep != null && this.getDirectory() != null) {
                return new JobMeta(LogWriter.getInstance(), rep, space != null ? space.environmentSubstitute(this.getJobName()) : this.getJobName(), rep.getDirectoryTree().findDirectory(this.environmentSubstitute(this.getDirectory())));
            }
            return new JobMeta(LogWriter.getInstance(), space != null ? space.environmentSubstitute(this.getFilename()) : this.getFilename(), rep, null);
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error during job metadata load", (Throwable)e);
        }
    }

    public boolean isExecPerRow() {
        return this.execPerRow;
    }

    public void setExecPerRow(boolean runEveryResultRow) {
        this.execPerRow = runEveryResultRow;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository) throws KettleException {
        this.copyVariablesFrom(space);
        JobMeta jobMeta = this.getJobMeta(repository, space);
        String proposedNewFilename = jobMeta.exportResources(jobMeta, definitions, namingInterface, repository);
        String newFilename = "${Internal.Job.Filename.Directory}/" + proposedNewFilename;
        jobMeta.setFilename(newFilename);
        this.filename = newFilename;
        return proposedNewFilename;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        if (this.setLogfile) {
            JobEntryValidatorUtils.andValidator().validate(this, "logfile", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
        if (null != this.directory) {
            JobEntryValidatorUtils.andValidator().validate(this, "directory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
            JobEntryValidatorUtils.andValidator().validate(this, "jobName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        } else {
            JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntryJob().check(remarks, null);
        System.out.printf("Remarks: %s\n", remarks);
    }

    protected String getLogfile() {
        return this.logfile;
    }

    public String getRemoteSlaveServerName() {
        return this.remoteSlaveServerName;
    }

    public void setRemoteSlaveServerName(String remoteSlaveServerName) {
        this.remoteSlaveServerName = remoteSlaveServerName;
    }

    public boolean isWaitingToFinish() {
        return this.waitingToFinish;
    }

    public void setWaitingToFinish(boolean waitingToFinish) {
        this.waitingToFinish = waitingToFinish;
    }

    public boolean isFollowingAbortRemotely() {
        return this.followingAbortRemotely;
    }

    public void setFollowingAbortRemotely(boolean followingAbortRemotely) {
        this.followingAbortRemotely = followingAbortRemotely;
    }

    public boolean isPassingAllParameters() {
        return this.passingAllParameters;
    }

    public void setPassingAllParameters(boolean passingAllParameters) {
        this.passingAllParameters = passingAllParameters;
    }
}

