/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.jdbcwrapper.CacheKey;
import ca.sqlpower.sql.jdbcwrapper.ConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.MetaDataCache;
import ca.sqlpower.sql.jdbcwrapper.ResultSetDecorator;
import ca.sqlpower.sql.jdbcwrapper.StatementDecorator;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public abstract class DatabaseMetaDataDecorator
implements DatabaseMetaData {
    protected DatabaseMetaData databaseMetaData;
    protected ConnectionDecorator connectionDecorator;
    protected static final ThreadLocal<CacheType> cacheType = new ThreadLocal();
    protected static final ThreadLocal<Date> cacheStaleDate = new ThreadLocal();
    public static final String CACHE_TYPE = "cacheType";
    public static final String CACHE_STALE_DATE = "cacheStaleDate";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T getCachedResult(MetaDataCache<CacheKey, T> cache, CacheKey key) {
        CacheType ct = cacheType.get();
        if (ct == CacheType.NO_CACHE) {
            return null;
        }
        MetaDataCache<CacheKey, T> metaDataCache = cache;
        synchronized (metaDataCache) {
            Date staleDate = cacheStaleDate.get();
            if (staleDate != null && cache.getLastFlushDate().before(staleDate)) {
                cache.flush();
                return null;
            }
            return cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void putCachedResult(MetaDataCache<CacheKey, T> cache, CacheKey key, T value) {
        CacheType ct = cacheType.get();
        if (ct == CacheType.NO_CACHE) {
            return;
        }
        MetaDataCache<CacheKey, T> metaDataCache = cache;
        synchronized (metaDataCache) {
            Date staleDate = cacheStaleDate.get();
            if (staleDate != null && cache.getLastFlushDate().before(staleDate)) {
                cache.flush();
            }
            cache.put(key, value);
        }
    }

    public DatabaseMetaDataDecorator(DatabaseMetaData delegate, ConnectionDecorator connectionDecorator) {
        this.databaseMetaData = delegate;
        this.connectionDecorator = connectionDecorator;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.databaseMetaData.allProceduresAreCallable();
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.databaseMetaData.allTablesAreSelectable();
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.databaseMetaData.dataDefinitionCausesTransactionCommit();
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.databaseMetaData.dataDefinitionIgnoredInTransactions();
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return this.databaseMetaData.deletesAreDetected(type);
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.databaseMetaData.doesMaxRowSizeIncludeBlobs();
    }

    public boolean equals(Object obj) {
        return this.databaseMetaData.equals(obj);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.wrap(this.databaseMetaData.getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern));
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.wrap(this.databaseMetaData.getBestRowIdentifier(catalog, schema, table, scope, nullable));
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.wrap(this.databaseMetaData.getCatalogs());
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return this.databaseMetaData.getCatalogSeparator();
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.databaseMetaData.getCatalogTerm();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.wrap(this.databaseMetaData.getColumnPrivileges(catalog, schema, table, columnNamePattern));
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.wrap(this.databaseMetaData.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern));
    }

    @Override
    public ConnectionDecorator getConnection() throws SQLException {
        return this.connectionDecorator;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.wrap(this.databaseMetaData.getCrossReference(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable));
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.databaseMetaData.getDatabaseMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.databaseMetaData.getDatabaseMinorVersion();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.databaseMetaData.getDatabaseProductName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.databaseMetaData.getDatabaseProductVersion();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.databaseMetaData.getDefaultTransactionIsolation();
    }

    @Override
    public int getDriverMajorVersion() {
        return this.databaseMetaData.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.databaseMetaData.getDriverMinorVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return this.databaseMetaData.getDriverName();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.databaseMetaData.getDriverVersion();
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.wrap(this.databaseMetaData.getExportedKeys(catalog, schema, table));
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return this.databaseMetaData.getExtraNameCharacters();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.databaseMetaData.getIdentifierQuoteString();
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.wrap(this.databaseMetaData.getImportedKeys(catalog, schema, table));
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.wrap(this.databaseMetaData.getIndexInfo(catalog, schema, table, unique, approximate));
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return this.databaseMetaData.getJDBCMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return this.databaseMetaData.getJDBCMinorVersion();
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.databaseMetaData.getMaxBinaryLiteralLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.databaseMetaData.getMaxCatalogNameLength();
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.databaseMetaData.getMaxCharLiteralLength();
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.databaseMetaData.getMaxColumnNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.databaseMetaData.getMaxColumnsInGroupBy();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.databaseMetaData.getMaxColumnsInIndex();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.databaseMetaData.getMaxColumnsInOrderBy();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.databaseMetaData.getMaxColumnsInSelect();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.databaseMetaData.getMaxColumnsInTable();
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.databaseMetaData.getMaxConnections();
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.databaseMetaData.getMaxCursorNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.databaseMetaData.getMaxIndexLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.databaseMetaData.getMaxProcedureNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.databaseMetaData.getMaxRowSize();
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.databaseMetaData.getMaxSchemaNameLength();
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.databaseMetaData.getMaxStatementLength();
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.databaseMetaData.getMaxStatements();
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.databaseMetaData.getMaxTableNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.databaseMetaData.getMaxTablesInSelect();
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.databaseMetaData.getMaxUserNameLength();
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.databaseMetaData.getNumericFunctions();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return this.wrap(this.databaseMetaData.getPrimaryKeys(catalog, schema, table));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.wrap(this.databaseMetaData.getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern));
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.wrap(this.databaseMetaData.getProcedures(catalog, schemaPattern, procedureNamePattern));
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return this.databaseMetaData.getProcedureTerm();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.databaseMetaData.getResultSetHoldability();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.wrap(this.databaseMetaData.getSchemas());
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.databaseMetaData.getSchemaTerm();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return this.databaseMetaData.getSearchStringEscape();
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.databaseMetaData.getSQLKeywords();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return this.databaseMetaData.getSQLStateType();
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.databaseMetaData.getStringFunctions();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.wrap(this.databaseMetaData.getSuperTables(catalog, schemaPattern, tableNamePattern));
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.wrap(this.databaseMetaData.getSuperTypes(catalog, schemaPattern, typeNamePattern));
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.databaseMetaData.getSystemFunctions();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.wrap(this.databaseMetaData.getTablePrivileges(catalog, schemaPattern, tableNamePattern));
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.wrap(this.databaseMetaData.getTables(catalog, schemaPattern, tableNamePattern, types));
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.wrap(this.databaseMetaData.getTableTypes());
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.databaseMetaData.getTimeDateFunctions();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.wrap(this.databaseMetaData.getTypeInfo());
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.wrap(this.databaseMetaData.getUDTs(catalog, schemaPattern, typeNamePattern, types));
    }

    @Override
    public String getURL() throws SQLException {
        return this.databaseMetaData.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.databaseMetaData.getUserName();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.wrap(this.databaseMetaData.getVersionColumns(catalog, schema, table));
    }

    public int hashCode() {
        return this.databaseMetaData.hashCode();
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return this.databaseMetaData.insertsAreDetected(type);
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.databaseMetaData.isCatalogAtStart();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.databaseMetaData.isReadOnly();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return this.databaseMetaData.locatorsUpdateCopy();
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.databaseMetaData.nullPlusNonNullIsNull();
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.databaseMetaData.nullsAreSortedAtEnd();
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.databaseMetaData.nullsAreSortedAtStart();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.databaseMetaData.nullsAreSortedHigh();
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.databaseMetaData.nullsAreSortedLow();
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return this.databaseMetaData.othersDeletesAreVisible(type);
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return this.databaseMetaData.othersInsertsAreVisible(type);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return this.databaseMetaData.othersUpdatesAreVisible(type);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return this.databaseMetaData.ownDeletesAreVisible(type);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return this.databaseMetaData.ownInsertsAreVisible(type);
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return this.databaseMetaData.ownUpdatesAreVisible(type);
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.databaseMetaData.storesLowerCaseIdentifiers();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.databaseMetaData.storesLowerCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.databaseMetaData.storesMixedCaseIdentifiers();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.databaseMetaData.storesMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.databaseMetaData.storesUpperCaseIdentifiers();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.databaseMetaData.storesUpperCaseQuotedIdentifiers();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.databaseMetaData.supportsAlterTableWithAddColumn();
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.databaseMetaData.supportsAlterTableWithDropColumn();
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return this.databaseMetaData.supportsANSI92EntryLevelSQL();
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return this.databaseMetaData.supportsANSI92FullSQL();
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return this.databaseMetaData.supportsANSI92IntermediateSQL();
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return this.databaseMetaData.supportsBatchUpdates();
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.databaseMetaData.supportsCatalogsInDataManipulation();
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.databaseMetaData.supportsCatalogsInIndexDefinitions();
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.databaseMetaData.supportsCatalogsInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.databaseMetaData.supportsCatalogsInProcedureCalls();
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.databaseMetaData.supportsCatalogsInTableDefinitions();
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return this.databaseMetaData.supportsColumnAliasing();
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return this.databaseMetaData.supportsConvert();
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return this.databaseMetaData.supportsConvert(fromType, toType);
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.databaseMetaData.supportsCoreSQLGrammar();
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.databaseMetaData.supportsCorrelatedSubqueries();
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions();
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.databaseMetaData.supportsDataManipulationTransactionsOnly();
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.databaseMetaData.supportsDifferentTableCorrelationNames();
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.databaseMetaData.supportsExpressionsInOrderBy();
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.databaseMetaData.supportsExtendedSQLGrammar();
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.databaseMetaData.supportsFullOuterJoins();
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return this.databaseMetaData.supportsGetGeneratedKeys();
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return this.databaseMetaData.supportsGroupBy();
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.databaseMetaData.supportsGroupByBeyondSelect();
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.databaseMetaData.supportsGroupByUnrelated();
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.databaseMetaData.supportsIntegrityEnhancementFacility();
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.databaseMetaData.supportsLikeEscapeClause();
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return this.databaseMetaData.supportsLimitedOuterJoins();
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.databaseMetaData.supportsMinimumSQLGrammar();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.databaseMetaData.supportsMixedCaseIdentifiers();
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.databaseMetaData.supportsMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return this.databaseMetaData.supportsMultipleOpenResults();
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return this.databaseMetaData.supportsMultipleResultSets();
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return this.databaseMetaData.supportsMultipleTransactions();
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return this.databaseMetaData.supportsNamedParameters();
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return this.databaseMetaData.supportsNonNullableColumns();
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.databaseMetaData.supportsOpenCursorsAcrossCommit();
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.databaseMetaData.supportsOpenCursorsAcrossRollback();
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.databaseMetaData.supportsOpenStatementsAcrossCommit();
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.databaseMetaData.supportsOpenStatementsAcrossRollback();
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.databaseMetaData.supportsOrderByUnrelated();
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return this.databaseMetaData.supportsOuterJoins();
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return this.databaseMetaData.supportsPositionedDelete();
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return this.databaseMetaData.supportsPositionedUpdate();
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return this.databaseMetaData.supportsResultSetConcurrency(type, concurrency);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return this.databaseMetaData.supportsResultSetHoldability(holdability);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return this.databaseMetaData.supportsResultSetType(type);
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.databaseMetaData.supportsSavepoints();
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.databaseMetaData.supportsSchemasInDataManipulation();
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.databaseMetaData.supportsSchemasInIndexDefinitions();
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.databaseMetaData.supportsSchemasInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.databaseMetaData.supportsSchemasInProcedureCalls();
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.databaseMetaData.supportsSchemasInTableDefinitions();
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return this.databaseMetaData.supportsSelectForUpdate();
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return this.databaseMetaData.supportsStatementPooling();
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.databaseMetaData.supportsStoredProcedures();
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.databaseMetaData.supportsSubqueriesInComparisons();
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.databaseMetaData.supportsSubqueriesInExists();
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.databaseMetaData.supportsSubqueriesInIns();
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.databaseMetaData.supportsSubqueriesInQuantifieds();
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.databaseMetaData.supportsTableCorrelationNames();
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return this.databaseMetaData.supportsTransactionIsolationLevel(level);
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.databaseMetaData.supportsTransactions();
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return this.databaseMetaData.supportsUnion();
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return this.databaseMetaData.supportsUnionAll();
    }

    public String toString() {
        return this.databaseMetaData.toString();
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return this.databaseMetaData.updatesAreDetected(type);
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.databaseMetaData.usesLocalFilePerTable();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.databaseMetaData.usesLocalFiles();
    }

    public static void putHint(String key, Object value) {
        if (key.equals(CACHE_TYPE)) {
            if (value instanceof CacheType) {
                cacheType.set((CacheType)((Object)value));
            } else {
                cacheType.set(null);
            }
        } else if (key.equals(CACHE_STALE_DATE)) {
            cacheStaleDate.set((Date)value);
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public ResultSet getFunctionColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public ResultSet getFunctions(String arg0, String arg1, String arg2) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public ResultSet getSchemas(String arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    protected abstract ResultSetDecorator wrap(ResultSet var1) throws SQLException;

    protected abstract StatementDecorator wrap(Statement var1) throws SQLException;

    public static enum CacheType {
        NO_CACHE,
        EAGER_CACHE;

    }
}

