/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class OgonekAtom
extends Atom {
    private static final SymbolAtom a = SymbolAtom.get("ogonek");
    private Atom a;

    public OgonekAtom(Atom atom) {
        this.a = atom;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        Box box;
        Box box2 = this.a.createBox(teXEnvironment);
        VerticalBox verticalBox = new VerticalBox();
        verticalBox.add(box2);
        Char char_ = teXEnvironment.getTeXFont().getChar("ogonek", teXEnvironment.getStyle());
        float f = char_.getItalic();
        CharBox charBox = new CharBox(char_);
        if (Math.abs(f) > 1.0E-7f) {
            box = new HorizontalBox(new StrutBox(-f, 0.0f, 0.0f, 0.0f));
            box.add(charBox);
        } else {
            box = charBox;
        }
        HorizontalBox horizontalBox = new HorizontalBox(box, box2.getWidth(), 1);
        verticalBox.add(new StrutBox(0.0f, -charBox.getHeight(), 0.0f, 0.0f));
        verticalBox.add(horizontalBox);
        float f2 = verticalBox.getHeight() + verticalBox.getDepth();
        verticalBox.setHeight(box2.getHeight());
        verticalBox.setDepth(f2 - box2.getHeight());
        return verticalBox;
    }
}

