/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instrumentation.reporting;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.instrumentation.reporting.MethodInterceptionReportCollector;

public class DefaultMethodInterceptionReportCollector
implements MethodInterceptionReportCollector,
Closeable {
    private final List<File> reports = new ArrayList<File>();

    @Override
    public void collect(File report) {
        this.reports.add(report);
    }

    @Override
    public void close() {
        if (this.reports.stream().mapToLong(File::length).sum() > 0L) {
            System.out.println("\nIntercepted methods:");
            this.reports.stream().flatMap(report -> {
                try {
                    return Files.readAllLines(report.toPath(), StandardCharsets.UTF_8).stream();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).distinct().forEach(System.out::println);
        }
        this.reports.clear();
    }
}

