/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.config.EventLogOptions;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.Topic;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Service
public final class EventLogConfigOptionsService {
    @Topic.AppLevel
    public static final Topic<EventLogConfigOptionsListener> TOPIC = new Topic(EventLogConfigOptionsListener.class, Topic.BroadcastDirection.NONE);

    public static EventLogConfigOptionsService getInstance() {
        return (EventLogConfigOptionsService)ApplicationManager.getApplication().getService(EventLogConfigOptionsService.class);
    }

    @NotNull
    public EventLogOptions getOptions(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(0);
        }
        return new EventLogOptions(EventLogMetadataSettingsPersistence.getInstance().getOptions(recorderId));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recorderId", "com/intellij/internal/statistic/eventLog/EventLogConfigOptionsService", "getOptions"));
    }

    public static abstract class EventLogThresholdConfigOptionsListener
    implements EventLogConfigOptionsListener {
        private final String myRecorderId;

        protected EventLogThresholdConfigOptionsListener(@NotNull String recorderId) {
            if (recorderId == null) {
                EventLogThresholdConfigOptionsListener.$$$reportNull$$$0(0);
            }
            this.myRecorderId = recorderId;
        }

        @Override
        public void optionsChanged(@NotNull String recorderId, @NotNull Map<String, String> options) {
            if (recorderId == null) {
                EventLogThresholdConfigOptionsListener.$$$reportNull$$$0(1);
            }
            if (options == null) {
                EventLogThresholdConfigOptionsListener.$$$reportNull$$$0(2);
            }
            if (StringUtil.equals((CharSequence)this.myRecorderId, (CharSequence)recorderId)) {
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    if (StringUtil.equals((CharSequence)name, (CharSequence)"dataThreshold")) {
                        this.onThresholdChanged(EventLogOptions.tryParseInt(value));
                    }
                    if (StringUtil.equals((CharSequence)name, (CharSequence)"groupDataThreshold")) {
                        this.onGroupThresholdChanged(EventLogOptions.tryParseInt(value));
                    }
                    if (!StringUtil.equals((CharSequence)name, (CharSequence)"groupAlertThreshold")) continue;
                    this.onGroupAlertThresholdChanged(EventLogOptions.tryParseInt(value));
                }
            }
        }

        public abstract void onThresholdChanged(int var1);

        public abstract void onGroupThresholdChanged(int var1);

        public abstract void onGroupAlertThresholdChanged(int var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recorderId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogConfigOptionsService$EventLogThresholdConfigOptionsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "optionsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

