/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions.vcs;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.config.TaskSettings;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.ui.TaskDialogPanel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsOpenTaskPanel
extends TaskDialogPanel {
    private JPanel myPanel;
    private JTextField myBranchName;
    private JTextField myChangelistName;
    private JBRadioButton myCreateBranch;
    private JBCheckBox myCreateChangelist;
    private ComboBox myBranchFrom;
    private JBLabel myFromLabel;
    private JBRadioButton myUseBranch;
    private ComboBox<VcsTaskHandler.TaskInfo> myUseBranchCombo;
    private JBCheckBox myShelveChanges;
    private JBRadioButton myDoNotAssociateBranch;
    private VcsTaskHandler myVcsTaskHandler;
    private static final String START_FROM_BRANCH = "start.from.branch";
    private final TaskManagerImpl myTaskManager;
    private final Project myProject;
    private final LocalTask myTask;
    private final LocalTask myPreviousTask;

    public VcsOpenTaskPanel(final Project project, LocalTask task) {
        VcsTaskHandler[] handlers;
        this.$$$setupUI$$$();
        this.myTaskManager = (TaskManagerImpl)TaskManager.getManager((Project)project);
        this.myProject = project;
        this.myTask = task;
        this.myBranchFrom.setMinimumAndPreferredWidth(JBUIScale.scale((int)150));
        this.myUseBranchCombo.setUsePreferredSizeAsMinimum(false);
        this.myPreviousTask = this.myTaskManager.getActiveTask();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsOpenTaskPanel.this.updateFields(false);
            }
        };
        this.myCreateChangelist.addActionListener(listener);
        this.myCreateBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsOpenTaskPanel.this.updateFields(false);
            }
        });
        this.myUseBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsOpenTaskPanel.this.updateFields(false);
            }
        });
        this.myDoNotAssociateBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsOpenTaskPanel.this.updateFields(false);
            }
        });
        this.myCreateChangelist.setSelected(this.myTaskManager.getState().createChangelist);
        this.myShelveChanges.setSelected(this.myTaskManager.getState().shelveChanges);
        this.myChangelistName.setText(this.getChangelistName((Task)task));
        if (!ChangeListManager.getInstance((Project)this.myProject).areChangeListsEnabled()) {
            this.myCreateChangelist.setVisible(false);
            this.myCreateChangelist.setSelected(false);
            this.myChangelistName.setVisible(false);
        }
        if ((handlers = VcsTaskHandler.getAllHandlers((Project)project)).length == 0) {
            this.myCreateBranch.setSelected(false);
            this.myCreateBranch.setVisible(false);
            this.myBranchName.setVisible(false);
            this.myFromLabel.setVisible(false);
            this.myBranchFrom.setVisible(false);
            this.myUseBranch.setSelected(false);
            this.myUseBranch.setVisible(false);
            this.myUseBranchCombo.setVisible(false);
            this.myDoNotAssociateBranch.setVisible(false);
        } else {
            String branchName = this.getBranchName((Task)task);
            for (VcsTaskHandler handler : handlers) {
                Object[] tasks = handler.getAllExistingTasks();
                if (tasks.length <= 0) continue;
                this.myVcsTaskHandler = handler;
                Arrays.sort(tasks);
                this.myBranchFrom.setModel(new DefaultComboBoxModel<Object>(tasks));
                this.myBranchFrom.setEnabled(true);
                this.myUseBranchCombo.setModel(new DefaultComboBoxModel<Object>(tasks));
                branchName = this.getBranchName((Task)task);
                for (Object info : tasks) {
                    if (!branchName.equals(info.getName()) && !task.getSummary().equals(info.getName())) continue;
                    this.myUseBranchCombo.setSelectedItem(info);
                    this.myUseBranch.setSelected(true);
                    break;
                }
                String startFrom = PropertiesComponent.getInstance((Project)project).getValue(START_FROM_BRANCH);
                VcsTaskHandler.TaskInfo info = null;
                if (startFrom != null) {
                    info = (VcsTaskHandler.TaskInfo)ContainerUtil.find((Object[])tasks, taskInfo -> startFrom.equals(taskInfo.getName()));
                }
                if (info == null) {
                    VcsTaskHandler.TaskInfo[] current = handler.getCurrentTasks();
                    info = current.length > 0 ? current[0] : tasks[0];
                }
                this.myBranchFrom.setSelectedItem((Object)info);
                this.myBranchFrom.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VcsTaskHandler.TaskInfo item = (VcsTaskHandler.TaskInfo)VcsOpenTaskPanel.this.myBranchFrom.getSelectedItem();
                        if (item != null) {
                            PropertiesComponent.getInstance((Project)project).setValue(VcsOpenTaskPanel.START_FROM_BRANCH, item.getName());
                        }
                    }
                });
                break;
            }
            if (!this.myUseBranch.isSelected()) {
                this.myCreateBranch.setSelected(this.myTaskManager.getState().createBranch && this.myBranchFrom.getItemCount() > 0);
                this.myUseBranch.setSelected(this.myTaskManager.getState().useBranch && this.myUseBranchCombo.getItemCount() > 0);
            }
            this.myBranchFrom.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", VcsTaskHandler.TaskInfo::getName));
            this.myUseBranchCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", VcsTaskHandler.TaskInfo::getName));
            this.myBranchName.setText(branchName);
            ComboboxSpeedSearch.installOn((JComboBox)this.myBranchFrom);
            ComboboxSpeedSearch.installOn(this.myUseBranchCombo);
        }
        this.updateFields(true);
    }

    private String getChangelistName(Task task) {
        return this.myTaskManager.getChangelistName(task);
    }

    @NotNull
    private String getBranchName(Task task) {
        String branchName = this.myTaskManager.suggestBranchName(task, StringUtil.notNullize((String)TaskSettings.getInstance().REPLACE_SPACES));
        if (this.myVcsTaskHandler != null) {
            this.myVcsTaskHandler.cleanUpBranchName(branchName);
        }
        String string = TaskSettings.getInstance().LOWER_CASE_BRANCH ? StringUtil.toLowerCase((String)branchName) : branchName;
        if (string == null) {
            VcsOpenTaskPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void updateFields(boolean initial) {
        if (!initial && this.myBranchFrom.getItemCount() == 0 && this.myCreateBranch.isSelected()) {
            Messages.showWarningDialog((Component)this.myPanel, (String)TaskBundle.message((String)"dialog.message.can.t.create.branch.if.no.commit.exists.create.commit.first", (Object[])new Object[0]), (String)TaskBundle.message((String)"dialog.title.cannot.create.branch", (Object[])new Object[0]));
            this.myCreateBranch.setSelected(false);
        }
        this.myBranchName.setEnabled(this.myCreateBranch.isSelected());
        this.myFromLabel.setEnabled(this.myCreateBranch.isSelected());
        this.myBranchFrom.setEnabled(this.myCreateBranch.isSelected());
        this.myUseBranchCombo.setEnabled(this.myUseBranch.isSelected());
        this.myChangelistName.setEnabled(this.myCreateChangelist.isSelected());
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            VcsOpenTaskPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public void commit() {
        VcsTaskHandler.TaskInfo branch;
        this.myTaskManager.getState().createChangelist = this.myCreateChangelist.isSelected();
        this.myTaskManager.getState().shelveChanges = this.myShelveChanges.isSelected();
        this.myTaskManager.getState().createBranch = this.myCreateBranch.isSelected();
        this.myTaskManager.getState().useBranch = this.myUseBranch.isSelected();
        if (this.myShelveChanges.isSelected()) {
            this.myTaskManager.shelveChanges(this.myPreviousTask, this.myPreviousTask.getSummary());
        }
        if (this.myCreateChangelist.isSelected()) {
            this.myTaskManager.createChangeList(this.myTask, this.myChangelistName.getText());
        } else {
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
            String comment = TaskUtil.getChangeListComment((Task)this.myTask);
            changeListManager.editComment(changeListManager.getDefaultListName(), comment);
        }
        if (this.myCreateBranch.isSelected()) {
            VcsTaskHandler.TaskInfo branchFrom = (VcsTaskHandler.TaskInfo)this.myBranchFrom.getSelectedItem();
            Runnable createBranch = () -> this.myTaskManager.createBranch(this.myTask, this.myPreviousTask, this.myBranchName.getText(), branchFrom);
            VcsTaskHandler.TaskInfo[] current = this.myVcsTaskHandler.getCurrentTasks();
            if (!(branchFrom == null || current.length != 0 && current[0].equals((Object)branchFrom))) {
                this.myVcsTaskHandler.switchToTask(branchFrom, createBranch);
            } else {
                createBranch.run();
            }
        }
        if (this.myUseBranch.isSelected() && (branch = (VcsTaskHandler.TaskInfo)this.myUseBranchCombo.getSelectedItem()) != null) {
            VcsTaskHandler.TaskInfo[] tasks = this.myVcsTaskHandler.getCurrentTasks();
            TaskManagerImpl.addBranches((LocalTask)this.myPreviousTask, (VcsTaskHandler.TaskInfo[])tasks, (boolean)true);
            this.myVcsTaskHandler.switchToTask(branch, () -> TaskManagerImpl.addBranches((LocalTask)this.myTask, (VcsTaskHandler.TaskInfo[])new VcsTaskHandler.TaskInfo[]{branch}, (boolean)false));
        }
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        if (this.myCreateBranch.isSelected()) {
            String branchName = this.myBranchName.getText().trim();
            if (branchName.isEmpty()) {
                return new ValidationInfo(TaskBundle.message((String)"dialog.message.branch.name.should.not.be.empty", (Object[])new Object[0]), (JComponent)this.myBranchName);
            }
            if (this.myVcsTaskHandler != null) {
                return this.myVcsTaskHandler.isBranchNameValid(branchName) ? null : new ValidationInfo(TaskBundle.message((String)"dialog.message.branch.name.not.valid.check.your.vcs.branch.name.restrictions", (Object[])new Object[0]), (JComponent)this.myBranchName);
            }
            if (branchName.contains(" ")) {
                return new ValidationInfo(TaskBundle.message((String)"dialog.message.branch.name.should.not.contain.spaces", (Object[])new Object[0]), (JComponent)this.myBranchName);
            }
            return null;
        }
        if (this.myCreateChangelist.isSelected() && this.myChangelistName.getText().trim().isEmpty()) {
            return new ValidationInfo(TaskBundle.message((String)"dialog.message.changelist.name.should.not.be.empty", (Object[])new Object[0]), (JComponent)this.myChangelistName);
        }
        return null;
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myCreateBranch.isSelected()) {
            return this.myBranchName;
        }
        if (this.myUseBranch.isSelected()) {
            return this.myUseBranchCombo;
        }
        if (this.myCreateChangelist.isSelected()) {
            return this.myChangelistName;
        }
        return null;
    }

    @Override
    public void taskNameChanged(Task oldTask, Task newTask) {
        if (this.getBranchName(oldTask).equals(this.myBranchName.getText())) {
            this.myBranchName.setText(this.getBranchName(newTask));
        }
        if (this.getChangelistName(oldTask).equals(this.myChangelistName.getText())) {
            this.myChangelistName.setText(this.getChangelistName(newTask));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/tasks/actions/vcs/VcsOpenTaskPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JBCheckBox jBCheckBox2;
        ComboBox comboBox;
        JBRadioButton jBRadioButton2;
        JBLabel jBLabel;
        ComboBox comboBox2;
        JBRadioButton jBRadioButton3;
        JTextField jTextField2;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/TaskBundle", VcsOpenTaskPanel.class).getString("vcs.operations"), (int)0, (int)0, null, null));
        this.myBranchName = jTextField2 = new JTextField();
        ((Component)jTextField2).setEnabled(false);
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCreateBranch = jBRadioButton3 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton3, DynamicBundle.getBundle((String)"messages/TaskBundle", VcsOpenTaskPanel.class).getString("create.branch"));
        jPanel.add((Component)jBRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBranchFrom = comboBox2 = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox2.setModel(defaultComboBoxModel);
        jPanel.add((Component)comboBox2, new GridConstraints(2, 3, 1, 1, 0, 0, 2, 0, null, null, null));
        this.myFromLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/TaskBundle", VcsOpenTaskPanel.class).getString("from"));
        jPanel.add((Component)jBLabel, new GridConstraints(2, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myUseBranch = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/TaskBundle", VcsOpenTaskPanel.class).getString("u.se.branch"));
        jPanel.add((Component)jBRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseBranchCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(3, 1, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myCreateChangelist = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/TaskBundle", VcsOpenTaskPanel.class).getString("create.change.list"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myChangelistName = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myShelveChanges = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/TaskBundle", VcsOpenTaskPanel.class).getString("s.helve.current.changes"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDoNotAssociateBranch = jBRadioButton = new JBRadioButton();
        jBRadioButton.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/TaskBundle", VcsOpenTaskPanel.class).getString("do.not.associate.branch"));
        jPanel.add((Component)jBRadioButton, new GridConstraints(4, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        jBLabel.setLabelFor((Component)comboBox2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton3);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

