/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.plugin.freeze;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.platform.diagnostic.plugin.freeze.MutedPlugin;
import com.intellij.platform.diagnostic.plugin.freeze.PluginsFreezesServiceState;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@State(name="PluginFreezes", storages={@Storage(value="pluginFreezes.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesServiceState;", "<init>", "()V", "state", "mutePlugin", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "mutedProblemVersion", "", "setLatestFreezeDate", "reset", "shouldBeIgnored", "", "getState", "loadState", "Companion", "intellij.platform.diagnostic.freezes"})
@SourceDebugExtension(value={"SMAP\nPluginsFreezesServiceState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginsFreezesServiceState.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1761#2,3:78\n1#3:81\n*S KotlinDebug\n*F\n+ 1 PluginsFreezesServiceState.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService\n*L\n54#1:78,3\n*E\n"})
public final class PluginsFreezesService
implements PersistentStateComponent<PluginsFreezesServiceState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PluginsFreezesServiceState state = new PluginsFreezesServiceState(null, null, 3, null);

    public final void mutePlugin(@NotNull PluginId pluginId) {
        MutedPlugin mutedPlugin;
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        String ideVersion = this.mutedProblemVersion();
        Collection collection = this.state.getMutedPlugins();
        MutedPlugin $this$mutePlugin_u24lambda_u240 = mutedPlugin = new MutedPlugin();
        boolean bl = false;
        $this$mutePlugin_u24lambda_u240.setPluginId(pluginId.getIdString());
        $this$mutePlugin_u24lambda_u240.setIdeVersion(ideVersion);
        collection.add(mutedPlugin);
        this.state.getMutedPlugins().removeIf(arg_0 -> PluginsFreezesService.mutePlugin$lambda$2(arg_0 -> PluginsFreezesService.mutePlugin$lambda$1(ideVersion, arg_0), arg_0));
    }

    private final String mutedProblemVersion() {
        ApplicationInfo app = ApplicationInfo.getInstance();
        return app.getMajorVersion() + "." + app.getMinorVersion();
    }

    public final void setLatestFreezeDate(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        this.state.getLatestNotificationTime().put(pluginId.getIdString(), Instant.now().toString());
    }

    public final void reset() {
        this.state.getLatestNotificationTime().clear();
        this.state.getMutedPlugins().clear();
    }

    public final boolean shouldBeIgnored(@NotNull PluginId pluginId) {
        Object object;
        block10: {
            block9: {
                boolean bl;
                String pluginIdString;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
                    pluginIdString = pluginId.getIdString();
                    String ideVersion = this.mutedProblemVersion();
                    Iterable $this$any$iv = this.state.getMutedPlugins();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MutedPlugin p = (MutedPlugin)((Object)element$iv);
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual((Object)p.getPluginId(), (Object)pluginIdString) && Intrinsics.areEqual((Object)p.getIdeVersion(), (Object)ideVersion))) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return true;
                }
                object = this.state.getLatestNotificationTime().get(pluginIdString);
                if (object == null) break block9;
                String it = object;
                boolean bl3 = false;
                Instant instant = Instant.parse(it);
                object = instant;
                if (instant != null) break block10;
            }
            return false;
        }
        Object lastNotification = object;
        return Instant.now().isBefore(((Instant)lastNotification).plus(1L, ChronoUnit.DAYS));
    }

    @NotNull
    public PluginsFreezesServiceState getState() {
        return this.state;
    }

    public void loadState(@NotNull PluginsFreezesServiceState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    private static final boolean mutePlugin$lambda$1(String $ideVersion, MutedPlugin it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return !Intrinsics.areEqual((Object)it.getIdeVersion(), (Object)$ideVersion);
    }

    private static final boolean mutePlugin$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final PluginsFreezesService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService;", "intellij.platform.diagnostic.freezes"})
    @SourceDebugExtension(value={"SMAP\nPluginsFreezesServiceState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginsFreezesServiceState.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,77:1\n42#2,3:78\n*S KotlinDebug\n*F\n+ 1 PluginsFreezesServiceState.kt\ncom/intellij/platform/diagnostic/plugin/freeze/PluginsFreezesService$Companion\n*L\n22#1:78,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PluginsFreezesService getInstance() {
            boolean $i$f$service = false;
            Class<PluginsFreezesService> serviceClass$iv = PluginsFreezesService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (PluginsFreezesService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

