/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.options;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class Options
implements Cloneable {
    private Map<String, LanguageOptions> options = new TreeMap<String, LanguageOptions>();
    private static final String LANG_TEMPLATE = "__TEMPLATE__";
    private static final Logger logger = Logger.getInstance((String)Options.class.getName());

    public LanguageOptions getOptions(String fileTypeName) {
        LanguageOptions res = this.options.get(fileTypeName);
        if (res != null) {
            return res;
        }
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName(fileTypeName);
        if (fileType == null) {
            return new LanguageOptions();
        }
        FileType acceptableFileType = CopyrightUpdaters.INSTANCE.getRegisteredFileTypeFromLanguageHierarchy(fileType);
        if (acceptableFileType != null && (res = this.options.get(acceptableFileType.getName())) != null) {
            return res;
        }
        UpdateCopyrightsProvider provider = CopyrightUpdaters.INSTANCE.forFileType(fileType);
        if (provider != null) {
            return provider.getDefaultOptions();
        }
        return new LanguageOptions();
    }

    public LanguageOptions getTemplateOptions() {
        return this.getOptions(LANG_TEMPLATE);
    }

    public void setOptions(String name, LanguageOptions options) {
        this.options.put(name, options);
    }

    public void setTemplateOptions(LanguageOptions options) {
        this.setOptions(LANG_TEMPLATE, options);
    }

    @Nullable
    public LanguageOptions getMergedOptions(String name) {
        try {
            LanguageOptions lang = this.getOptions(name).clone();
            LanguageOptions temp = this.getTemplateOptions().clone();
            switch (lang.getFileTypeOverride()) {
                case 2: {
                    temp.setFileLocation(lang.getFileLocation());
                    temp.setFileTypeOverride(lang.getFileTypeOverride());
                    lang = temp;
                    break;
                }
            }
            return lang;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        logger.debug("readExternal()");
        List languageOptions = element.getChildren("LanguageOptions");
        if (!languageOptions.isEmpty()) {
            for (int i = 0; i < languageOptions.size(); ++i) {
                Element languageOption = (Element)languageOptions.get(i);
                LanguageOptions opts = new LanguageOptions();
                opts.readExternal(languageOption);
                this.setOptions(languageOption.getAttributeValue("name"), opts);
            }
        } else {
            Element root = null;
            Element jOpts = element.getChild("JavaOptions");
            if (jOpts != null) {
                root = jOpts;
            } else {
                Element child = element.getChild("option");
                if (child != null && child.getAttribute("name") != null) {
                    root = element;
                }
            }
            if (root != null) {
                String languageName = StdFileTypes.JAVA.getName();
                LanguageOptions opts = new LanguageOptions();
                opts.setFileTypeOverride(2);
                for (Element option : root.getChildren("option")) {
                    String name = option.getAttributeValue("name");
                    String val = option.getAttributeValue("value");
                    if (!"location".equals(name) || val == null) continue;
                    opts.setFileLocation(Integer.parseInt(val));
                }
                this.setOptions(languageName, opts);
            }
        }
        logger.debug("options=" + String.valueOf(this));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        logger.debug("writeExternal()");
        for (String lang : this.options.keySet()) {
            Element elem = new Element("LanguageOptions");
            elem.setAttribute("name", lang);
            element.addContent(elem);
            this.options.get(lang).writeExternal(elem);
        }
        logger.debug("options=" + String.valueOf(this));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options options1 = (Options)o;
        return this.options.equals(options1.options);
    }

    public int hashCode() {
        int result = this.options.hashCode();
        return result;
    }

    public String toString() {
        return "Options{options=" + String.valueOf(this.options) + "}";
    }

    public Options clone() throws CloneNotSupportedException {
        Options res = (Options)super.clone();
        res.options = new TreeMap<String, LanguageOptions>();
        for (String lang : this.options.keySet()) {
            LanguageOptions opts = this.options.get(lang);
            res.options.put(lang, opts.clone());
        }
        return res;
    }
}

