/*
 * Decompiled with CFR 0.152.
 */
package org.jf.smali;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.StringReader;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.MemoryDataStore;
import org.jf.smali.smaliFlexLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;

public class SmaliTestUtils {
    public static DexBackedClassDef compileSmali(String smaliText) throws RecognitionException, IOException {
        return SmaliTestUtils.compileSmali(smaliText, 15);
    }

    public static DexBackedClassDef compileSmali(String smaliText, int apiLevel) throws RecognitionException, IOException {
        DexBuilder dexBuilder = new DexBuilder(Opcodes.forApi((int)apiLevel));
        StringReader reader = new StringReader(smaliText);
        smaliFlexLexer lexer = new smaliFlexLexer(reader, apiLevel);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        smaliParser parser = new smaliParser((TokenStream)tokens);
        parser.setVerboseErrors(true);
        parser.setAllowOdex(false);
        parser.setApiLevel(apiLevel);
        smaliParser.smali_file_return result = parser.smali_file();
        if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
            throw new RuntimeException("Error occurred while compiling text");
        }
        CommonTree t = result.getTree();
        CommonTreeNodeStream treeStream = new CommonTreeNodeStream((Object)t);
        treeStream.setTokenStream((TokenStream)tokens);
        smaliTreeWalker dexGen = new smaliTreeWalker((TreeNodeStream)treeStream);
        dexGen.setApiLevel(apiLevel);
        dexGen.setVerboseErrors(true);
        dexGen.setDexBuilder(dexBuilder);
        dexGen.smali_file();
        if (dexGen.getNumberOfSyntaxErrors() > 0) {
            throw new RuntimeException("Error occurred while compiling text");
        }
        MemoryDataStore dataStore = new MemoryDataStore();
        dexBuilder.writeTo((DexDataStore)dataStore);
        DexBackedDexFile dexFile = new DexBackedDexFile(Opcodes.forApi((int)apiLevel), dataStore.getBuffer());
        return (DexBackedClassDef)Iterables.getFirst((Iterable)dexFile.getClasses(), null);
    }
}

