/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.PartitionLeaderStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidMetadataException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public final class DeleteRecordsHandler
extends AdminApiHandler.Batched<TopicPartition, DeletedRecords> {
    private final Map<TopicPartition, RecordsToDelete> recordsToDelete;
    private final Logger log;
    private final AdminApiLookupStrategy<TopicPartition> lookupStrategy;
    private final int timeout;

    public DeleteRecordsHandler(Map<TopicPartition, RecordsToDelete> recordsToDelete, LogContext logContext, int timeout) {
        this.recordsToDelete = recordsToDelete;
        this.log = logContext.logger(DeleteRecordsHandler.class);
        this.lookupStrategy = new PartitionLeaderStrategy(logContext);
        this.timeout = timeout;
    }

    @Override
    public String apiName() {
        return "deleteRecords";
    }

    @Override
    public AdminApiLookupStrategy<TopicPartition> lookupStrategy() {
        return this.lookupStrategy;
    }

    public static AdminApiFuture.SimpleAdminApiFuture<TopicPartition, DeletedRecords> newFuture(Collection<TopicPartition> topicPartitions) {
        return AdminApiFuture.forKeys(new HashSet<TopicPartition>(topicPartitions));
    }

    public DeleteRecordsRequest.Builder buildBatchedRequest(int brokerId, Set<TopicPartition> keys) {
        HashMap<String, DeleteRecordsRequestData.DeleteRecordsTopic> deletionsForTopic = new HashMap<String, DeleteRecordsRequestData.DeleteRecordsTopic>();
        for (TopicPartition topicPartition : keys) {
            RecordsToDelete toDelete = this.recordsToDelete.get(topicPartition);
            DeleteRecordsRequestData.DeleteRecordsTopic deleteRecords = deletionsForTopic.computeIfAbsent(topicPartition.topic(), key -> new DeleteRecordsRequestData.DeleteRecordsTopic().setName(topicPartition.topic()));
            deleteRecords.partitions().add(new DeleteRecordsRequestData.DeleteRecordsPartition().setPartitionIndex(topicPartition.partition()).setOffset(toDelete.beforeOffset()));
        }
        DeleteRecordsRequestData data = new DeleteRecordsRequestData().setTopics(new ArrayList<DeleteRecordsRequestData.DeleteRecordsTopic>(deletionsForTopic.values())).setTimeoutMs(this.timeout);
        return new DeleteRecordsRequest.Builder(data);
    }

    @Override
    public AdminApiHandler.ApiResult<TopicPartition, DeletedRecords> handleResponse(Node broker, Set<TopicPartition> keys, AbstractResponse abstractResponse) {
        DeleteRecordsResponse response = (DeleteRecordsResponse)abstractResponse;
        HashMap<TopicPartition, DeletedRecords> completed = new HashMap<TopicPartition, DeletedRecords>();
        HashMap<TopicPartition, Throwable> failed = new HashMap<TopicPartition, Throwable>();
        ArrayList<TopicPartition> unmapped = new ArrayList<TopicPartition>();
        HashSet<TopicPartition> retriable = new HashSet<TopicPartition>();
        for (DeleteRecordsResponseData.DeleteRecordsTopicResult topicResult : response.data().topics()) {
            for (DeleteRecordsResponseData.DeleteRecordsPartitionResult partitionResult : topicResult.partitions()) {
                Errors error = Errors.forCode(partitionResult.errorCode());
                TopicPartition topicPartition = new TopicPartition(topicResult.name(), partitionResult.partitionIndex());
                if (error == Errors.NONE) {
                    completed.put(topicPartition, new DeletedRecords(partitionResult.lowWatermark()));
                    continue;
                }
                this.handlePartitionError(topicPartition, error, failed, unmapped, retriable);
            }
        }
        for (TopicPartition topicPartition : keys) {
            if (!unmapped.isEmpty() || completed.containsKey(topicPartition) || failed.containsKey(topicPartition) || retriable.contains(topicPartition)) continue;
            ApiException sanityCheckException = new ApiException("The response from broker " + broker.id() + " did not contain a result for topic partition " + topicPartition);
            this.log.error("DeleteRecords request for topic partition {} failed sanity check", (Object)topicPartition, (Object)sanityCheckException);
            failed.put(topicPartition, sanityCheckException);
        }
        return new AdminApiHandler.ApiResult<TopicPartition, DeletedRecords>(completed, failed, unmapped);
    }

    private void handlePartitionError(TopicPartition topicPartition, Errors error, Map<TopicPartition, Throwable> failed, List<TopicPartition> unmapped, Set<TopicPartition> retriable) {
        if (error.exception() instanceof InvalidMetadataException) {
            this.log.debug("DeleteRecords lookup request for topic partition {} will be retried due to invalid leader metadata {}", (Object)topicPartition, (Object)error);
            unmapped.add(topicPartition);
        } else if (error.exception() instanceof RetriableException) {
            this.log.debug("DeleteRecords fulfillment request for topic partition {} will be retried due to {}", (Object)topicPartition, (Object)error);
            retriable.add(topicPartition);
        } else if (error.exception() instanceof TopicAuthorizationException) {
            this.log.error("DeleteRecords request for topic partition {} failed due to an error {}", (Object)topicPartition, (Object)error);
            failed.put(topicPartition, error.exception());
        } else {
            this.log.error("DeleteRecords request for topic partition {} failed due to an unexpected error {}", (Object)topicPartition, (Object)error);
            failed.put(topicPartition, error.exception());
        }
    }
}

