/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import org.apache.derby.iapi.services.monitor.PersistentService;

class ModuleInstance {
    protected Object instance;
    protected String identifier;
    protected Object topLevelService;
    protected Object service;
    private boolean booted;

    protected ModuleInstance(Object instance, String identifier, Object service, Object topLevelService) {
        this.instance = instance;
        this.identifier = identifier;
        this.topLevelService = topLevelService;
        this.service = service;
    }

    protected ModuleInstance(Object instance) {
        this(instance, null, null, null);
    }

    protected boolean isTypeAndName(PersistentService serviceType, Class factoryInterface, String otherCanonicalName) {
        if (!factoryInterface.isInstance(this.instance)) {
            return false;
        }
        if (serviceType != null && otherCanonicalName != null) {
            return serviceType.isSameService(this.identifier, otherCanonicalName);
        }
        if (otherCanonicalName != null) {
            if (this.identifier == null) {
                return false;
            }
            if (!otherCanonicalName.equals(this.identifier)) {
                return false;
            }
        } else if (this.identifier != null) {
            return false;
        }
        return true;
    }

    protected String getIdentifier() {
        return this.identifier;
    }

    protected Object getTopLevelService() {
        return this.topLevelService;
    }

    protected Object getInstance() {
        return this.instance;
    }

    synchronized void setBooted() {
        this.booted = true;
    }

    synchronized boolean isBooted() {
        return this.booted;
    }
}

