/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LZ4_streamDecode_t_internal")
public class LZ4StreamDecodeInternal
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXTERNALDICT;
    public static final int EXTDICTSIZE;
    public static final int PREFIXEND;
    public static final int PREFIXSIZE;

    public LZ4StreamDecodeInternal(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LZ4StreamDecodeInternal.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LZ4_byte const *")
    public ByteBuffer externalDict(int capacity) {
        return LZ4StreamDecodeInternal.nexternalDict(this.address(), capacity);
    }

    @NativeType(value="size_t")
    public long extDictSize() {
        return LZ4StreamDecodeInternal.nextDictSize(this.address());
    }

    @NativeType(value="LZ4_byte const *")
    public ByteBuffer prefixEnd(int capacity) {
        return LZ4StreamDecodeInternal.nprefixEnd(this.address(), capacity);
    }

    @NativeType(value="size_t")
    public long prefixSize() {
        return LZ4StreamDecodeInternal.nprefixSize(this.address());
    }

    public static LZ4StreamDecodeInternal create(long address) {
        return (LZ4StreamDecodeInternal)LZ4StreamDecodeInternal.wrap(LZ4StreamDecodeInternal.class, (long)address);
    }

    @Nullable
    public static LZ4StreamDecodeInternal createSafe(long address) {
        return address == 0L ? null : (LZ4StreamDecodeInternal)LZ4StreamDecodeInternal.wrap(LZ4StreamDecodeInternal.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LZ4StreamDecodeInternal.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LZ4StreamDecodeInternal.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static ByteBuffer nexternalDict(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)EXTERNALDICT)), (int)capacity);
    }

    public static long nextDictSize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)EXTDICTSIZE));
    }

    public static ByteBuffer nprefixEnd(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PREFIXEND)), (int)capacity);
    }

    public static long nprefixSize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PREFIXSIZE));
    }

    static {
        Struct.Layout layout = LZ4StreamDecodeInternal.__struct((Struct.Member[])new Struct.Member[]{LZ4StreamDecodeInternal.__member((int)POINTER_SIZE), LZ4StreamDecodeInternal.__member((int)POINTER_SIZE), LZ4StreamDecodeInternal.__member((int)POINTER_SIZE), LZ4StreamDecodeInternal.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXTERNALDICT = layout.offsetof(0);
        EXTDICTSIZE = layout.offsetof(1);
        PREFIXEND = layout.offsetof(2);
        PREFIXSIZE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<LZ4StreamDecodeInternal, Buffer> {
        private static final LZ4StreamDecodeInternal ELEMENT_FACTORY = LZ4StreamDecodeInternal.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LZ4StreamDecodeInternal getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LZ4_byte const *")
        public ByteBuffer externalDict(int capacity) {
            return LZ4StreamDecodeInternal.nexternalDict(this.address(), capacity);
        }

        @NativeType(value="size_t")
        public long extDictSize() {
            return LZ4StreamDecodeInternal.nextDictSize(this.address());
        }

        @NativeType(value="LZ4_byte const *")
        public ByteBuffer prefixEnd(int capacity) {
            return LZ4StreamDecodeInternal.nprefixEnd(this.address(), capacity);
        }

        @NativeType(value="size_t")
        public long prefixSize() {
            return LZ4StreamDecodeInternal.nprefixSize(this.address());
        }
    }
}

