/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteIcon;
import CH.ifa.draw.util.PaletteListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class ToolButton
extends PaletteButton {
    private String fName;
    private Tool fTool;
    private PaletteIcon fIcon;

    public ToolButton(PaletteListener paletteListener, String string, String string2, Tool tool) {
        super(paletteListener);
        Iconkit iconkit = Iconkit.instance();
        if (iconkit == null) {
            throw new HJDError("Iconkit instance isn't set");
        }
        Image[] imageArray = new Image[]{iconkit.loadImageResource(string + "1.gif"), iconkit.loadImageResource(string + "2.gif"), iconkit.loadImageResource(string + "3.gif")};
        MediaTracker mediaTracker = new MediaTracker(this);
        for (int i = 0; i < 3; ++i) {
            mediaTracker.addImage(imageArray[i], i);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Bugger " + exception.getMessage() + " " + string);
        }
        this.fIcon = new PaletteIcon(new Dimension(24, 24), imageArray[0], imageArray[1], imageArray[2]);
        this.fTool = tool;
        this.fName = string2;
    }

    public Tool tool() {
        return this.fTool;
    }

    public String name() {
        return this.fName;
    }

    public Object attributeValue() {
        return this.tool();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.fIcon.getWidth(), this.fIcon.getHeight());
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.fIcon.getWidth(), this.fIcon.getHeight());
    }

    public void paintBackground(Graphics graphics) {
    }

    public void paintNormal(Graphics graphics) {
        if (this.fIcon.normal() != null) {
            graphics.drawImage(this.fIcon.normal(), 0, 0, this);
        }
    }

    public void paintPressed(Graphics graphics) {
        if (this.fIcon.pressed() != null) {
            graphics.drawImage(this.fIcon.pressed(), 0, 0, this);
        }
    }

    public void paintSelected(Graphics graphics) {
        if (this.fIcon.selected() != null) {
            graphics.drawImage(this.fIcon.selected(), 0, 0, this);
        }
    }
}

