/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l % i64vec3(167l, 66l, 187l)) => i64vec3(0l, 0l, 0l)
 * (3l % i64vec3(167l, 66l, 187l)) => i64vec3(3l, 3l, 3l)
 * (1048576l % i64vec3(167l, 66l, 187l)) => i64vec3(150l, 34l, 67l)
 * (4251475l % i64vec3(167l, 66l, 187l)) => i64vec3(156l, 19l, 30l)
 * (29852643761l % i64vec3(167l, 66l, 187l)) => i64vec3(146l, 17l, 39l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0l % i64vec3(167l, 66l, 187l)), i64vec3(0l, 0l, 0l))) ? 1 : -1] array0;
  float[all(equal((3l % i64vec3(167l, 66l, 187l)), i64vec3(3l, 3l, 3l))) ? 1 : -1] array1;
  float[all(equal((1048576l % i64vec3(167l, 66l, 187l)), i64vec3(150l, 34l, 67l))) ? 1 : -1] array2;
  float[all(equal((4251475l % i64vec3(167l, 66l, 187l)), i64vec3(156l, 19l, 30l))) ? 1 : -1] array3;
  float[all(equal((29852643761l % i64vec3(167l, 66l, 187l)), i64vec3(146l, 17l, 39l))) ? 1 : -1] array4;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
