/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.algorithm;

import com.projectlibre1.algorithm.DoubleValue;
import com.projectlibre1.algorithm.IntervalGenerator;
import com.projectlibre1.algorithm.IntervalValue;
import com.projectlibre1.algorithm.Query;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.collections.Closure;

public class Merge
implements Closure {
    boolean started = false;
    long currentStart;
    long currentEnd;
    Object currentObject = null;
    Closure callBack;
    Comparator comparator = null;

    public static Merge getInstance(Closure closure) {
        return new Merge(closure);
    }

    public static Merge getInstance(Closure closure, Comparator comparator) {
        return new Merge(closure, comparator);
    }

    private Merge(Closure closure) {
        this.callBack = closure;
        this.initializeDates();
    }

    private Merge(Closure closure, Comparator comparator) {
        this(closure);
        this.comparator = comparator;
    }

    public void setCallBack(Closure closure) {
        this.callBack = closure;
    }

    private void initializeDates() {
        this.currentStart = Long.MAX_VALUE;
        this.currentEnd = Long.MIN_VALUE;
    }

    private void treatCurrentInterval() {
        double d = 0.0;
        if (this.currentObject != null) {
            d = ((DoubleValue)this.currentObject).getValue();
        }
        this.callBack.execute(IntervalValue.getInstance(this.currentStart, this.currentEnd, d));
        this.started = false;
        this.initializeDates();
    }

    @Override
    public void execute(Object object) {
        Query query = (Query)object;
        IntervalGenerator intervalGenerator = query.getGroupByGenerator();
        if (intervalGenerator.isCurrentActive()) {
            if (this.started && this.comparator != null && this.comparator.compare(this.currentObject, intervalGenerator.current()) != 0) {
                this.treatCurrentInterval();
            }
            this.currentObject = intervalGenerator.current();
            this.started = true;
            this.currentStart = Math.min(this.currentStart, query.getStart());
            this.currentEnd = Math.max(this.currentEnd, query.getEnd());
            if (!intervalGenerator.hasNext()) {
                this.treatCurrentInterval();
            }
        } else if (intervalGenerator.current() != null) {
            this.started = false;
            this.treatCurrentInterval();
        }
    }

    public class MergedInterval {
        long start;
        long end;
        Object template;

        public MergedInterval(Merge merge, long l, long l2, Object object) {
            this.start = l;
            this.end = l2;
            this.template = object;
        }

        public long getEnd() {
            return this.end;
        }

        public long getStart() {
            return this.start;
        }

        public Object getTemplate() {
            return this.template;
        }

        public String toString() {
            return String.valueOf(new Date(this.start)) + "-" + String.valueOf(new Date(this.end)) + String.valueOf(this.template);
        }
    }
}

