/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;

public abstract class JRFillChartDataset
implements JRChartDataset {
    protected JRChartDataset parent = null;
    protected JRGroup resetGroup = null;
    protected JRGroup incrementGroup = null;
    private boolean isIncremented = true;

    protected JRFillChartDataset(JRChartDataset dataset, JRFillObjectFactory factory) {
        factory.put(dataset, this);
        this.parent = dataset;
        this.resetGroup = factory.getGroup(dataset.getResetGroup());
        this.incrementGroup = factory.getGroup(dataset.getIncrementGroup());
    }

    public byte getResetType() {
        return this.parent.getResetType();
    }

    public byte getIncrementType() {
        return this.parent.getIncrementType();
    }

    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }

    protected void initialize() {
        this.customInitialize();
        this.isIncremented = false;
    }

    protected void evaluate(JRCalculator calculator) throws JRExpressionEvalException {
        this.customEvaluate(calculator);
        this.isIncremented = false;
    }

    protected void increment() {
        if (!this.isIncremented) {
            this.customIncrement();
        }
        this.isIncremented = true;
    }

    public Dataset getDataset() {
        this.increment();
        return this.getCustomDataset();
    }

    protected abstract void customInitialize();

    protected abstract void customEvaluate(JRCalculator var1) throws JRExpressionEvalException;

    protected abstract void customIncrement();

    protected abstract Dataset getCustomDataset();
}

