/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.psi.tree.IElementType;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.stubs.MarkdownStubBasedPsiElementBase;
import org.intellij.plugins.markdown.lang.stubs.MarkdownStubElement;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElement;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElementType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Please use {@link MarkdownHeader} instead.", replaceWith=@ReplaceWith(expression="MarkdownHeader", imports={}))
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b'\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u00020\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0004\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderImpl;", "Lorg/intellij/plugins/markdown/lang/stubs/MarkdownStubBasedPsiElementBase;", "Lorg/intellij/plugins/markdown/lang/stubs/MarkdownStubElement;", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElement;", "type", "Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType;", "(Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElement;Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType;)V", "calculateHeaderLevel", "", "intellij.markdown"})
@ApiStatus.ScheduledForRemoval
public abstract class MarkdownHeaderImpl
extends MarkdownStubBasedPsiElementBase<MarkdownStubElement<?>>
implements PsiExternalReferenceHost {
    public MarkdownHeaderImpl(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public MarkdownHeaderImpl(@NotNull MarkdownHeaderStubElement stub, @NotNull MarkdownHeaderStubElementType type) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super((MarkdownStubElement)stub, type);
    }

    protected final int calculateHeaderLevel() {
        int n;
        IElementType iElementType = this.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType type = iElementType;
        if (MarkdownTokenTypeSets.HEADER_LEVEL_1_SET.contains(type)) {
            n = 1;
        } else if (MarkdownTokenTypeSets.HEADER_LEVEL_2_SET.contains(type)) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)type, (Object)MarkdownElementTypes.ATX_3)) {
            n = 3;
        } else if (Intrinsics.areEqual((Object)type, (Object)MarkdownElementTypes.ATX_4)) {
            n = 4;
        } else if (Intrinsics.areEqual((Object)type, (Object)MarkdownElementTypes.ATX_5)) {
            n = 5;
        } else if (Intrinsics.areEqual((Object)type, (Object)MarkdownElementTypes.ATX_6)) {
            n = 6;
        } else {
            throw new IllegalStateException("Type should be one of header types");
        }
        return n;
    }
}

