/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.engine.extension.TimeoutConfiguration;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.jupiter.engine.extension.TimeoutInvocation;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ReflectionUtils;

class TimeoutExtension
implements BeforeAllCallback,
BeforeEachCallback,
InvocationInterceptor {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{Timeout.class});
    private static final String TESTABLE_METHOD_TIMEOUT_KEY = "testable_method_timeout_from_annotation";
    private static final String GLOBAL_TIMEOUT_CONFIG_KEY = "global_timeout_config";

    TimeoutExtension() {
    }

    public void beforeAll(ExtensionContext context) {
        this.readAndStoreTimeoutSoChildrenInheritIt(context);
    }

    public void beforeEach(ExtensionContext context) {
        this.readAndStoreTimeoutSoChildrenInheritIt(context);
    }

    private void readAndStoreTimeoutSoChildrenInheritIt(ExtensionContext context) {
        this.readTimeoutFromAnnotation(context.getElement()).ifPresent(timeout -> context.getStore(NAMESPACE).put((Object)TESTABLE_METHOD_TIMEOUT_KEY, timeout));
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultBeforeAllMethodTimeout);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultBeforeEachMethodTimeout);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptTestableMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestMethodTimeout);
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptTestableMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestTemplateMethodTimeout);
    }

    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        return this.interceptTestableMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestFactoryMethodTimeout);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultAfterEachMethodTimeout);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultAfterAllMethodTimeout);
    }

    private void interceptLifecycleMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout = this.readTimeoutFromAnnotation(Optional.of(invocationContext.getExecutable())).orElse(null);
        this.intercept(invocation, invocationContext, extensionContext, timeout, defaultTimeoutProvider);
    }

    private Optional<TimeoutDuration> readTimeoutFromAnnotation(Optional<AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, Timeout.class).map(TimeoutDuration::from);
    }

    private <T> T interceptTestableMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout = (TimeoutDuration)extensionContext.getStore(NAMESPACE).get((Object)TESTABLE_METHOD_TIMEOUT_KEY, TimeoutDuration.class);
        return this.intercept(invocation, invocationContext, extensionContext, timeout, defaultTimeoutProvider);
    }

    private <T> T intercept(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutDuration explicitTimeout, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout = explicitTimeout == null ? this.getDefaultTimeout(extensionContext, defaultTimeoutProvider) : explicitTimeout;
        return (T)this.decorate(invocation, invocationContext, extensionContext, timeout).proceed();
    }

    private TimeoutDuration getDefaultTimeout(ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) {
        return ((Optional)defaultTimeoutProvider.apply(this.getGlobalTimeoutConfiguration(extensionContext))).orElse(null);
    }

    private TimeoutConfiguration getGlobalTimeoutConfiguration(ExtensionContext extensionContext) {
        ExtensionContext root = extensionContext.getRoot();
        return (TimeoutConfiguration)root.getStore(NAMESPACE).getOrComputeIfAbsent((Object)GLOBAL_TIMEOUT_CONFIG_KEY, key -> new TimeoutConfiguration(root), TimeoutConfiguration.class);
    }

    private <T> InvocationInterceptor.Invocation<T> decorate(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutDuration timeout) {
        if (timeout == null) {
            return invocation;
        }
        return new TimeoutInvocation<T>(invocation, timeout, this.getExecutor(extensionContext), () -> this.describe(invocationContext, extensionContext));
    }

    private String describe(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        Method method = (Method)invocationContext.getExecutable();
        Optional testClass = extensionContext.getTestClass();
        if (testClass.isPresent() && invocationContext.getTargetClass().equals(testClass.get())) {
            return String.format("%s(%s)", method.getName(), ClassUtils.nullSafeToString((Class[])method.getParameterTypes()));
        }
        return ReflectionUtils.getFullyQualifiedMethodName((Class)invocationContext.getTargetClass(), (Method)method);
    }

    private ScheduledExecutorService getExecutor(ExtensionContext extensionContext) {
        return ((ExecutorResource)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent(ExecutorResource.class)).get();
    }

    private static class ExecutorResource
    implements ExtensionContext.Store.CloseableResource {
        private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "junit-jupiter-timeout-watcher");
            thread.setPriority(10);
            return thread;
        });

        ExecutorResource() {
        }

        ScheduledExecutorService get() {
            return this.executor;
        }

        public void close() throws Throwable {
            this.executor.shutdown();
            boolean terminated = this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            if (!terminated) {
                this.executor.shutdownNow();
                throw new JUnitException("Scheduled executor could not be stopped in an orderly manner");
            }
        }
    }

    @FunctionalInterface
    private static interface TimeoutProvider
    extends Function<TimeoutConfiguration, Optional<TimeoutDuration>> {
    }
}

